/*
 * Decompiled with CFR 0.152.
 */
package cloud.elit.sdk.nlp.structure;

import cloud.elit.sdk.nlp.structure.Chunk;
import cloud.elit.sdk.nlp.structure.Sentence;
import cloud.elit.sdk.nlp.structure.node.AbstractNode;
import cloud.elit.sdk.nlp.structure.node.NLPNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Document
implements Serializable,
Iterable<Sentence> {
    private List<Sentence> sentences = new ArrayList<Sentence>();

    public Document() {
    }

    public Document(String json) {
        this();
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode top = mapper.readTree(json);
            JsonNode output = top.findValue("output");
            for (JsonNode o : output) {
                int sen_id = o.findValue("sid").asInt();
                List<NLPNode> nodes = this.toNodeList(o.findValue("tok"));
                Sentence sentence = new Sentence(sen_id, nodes);
                this.add(sentence);
                this.setOffsets(nodes, o.findValue("off"));
                this.setStringList(nodes, o.findValue("lem"), AbstractNode::setLemma);
                this.setStringList(nodes, o.findValue("pos"), NLPNode::setPartOfSpeechTag);
                sentence.setNamedEntities(this.toEntityList(nodes, o.findValue("ner")));
                this.setPrimaryDependencies(sentence, o.findValue("dep"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<NLPNode> toNodeList(JsonNode json) {
        ArrayList<NLPNode> list = new ArrayList<NLPNode>();
        int i = 0;
        for (JsonNode token : json) {
            list.add(new NLPNode(i++, token.asText()));
        }
        return list;
    }

    private void setOffsets(List<NLPNode> nodes, JsonNode json) {
        if (json == null) {
            return;
        }
        int i = 0;
        for (JsonNode node : json) {
            Iterator it = node.iterator();
            nodes.get(i).setBeginOffset(((JsonNode)it.next()).asInt());
            nodes.get(i++).setEndOffset(((JsonNode)it.next()).asInt());
        }
    }

    private void setStringList(List<NLPNode> nodes, JsonNode json, BiConsumer<NLPNode, String> c) {
        if (json == null) {
            return;
        }
        int i = 0;
        for (JsonNode node : json) {
            c.accept(nodes.get(i++), node.asText());
        }
    }

    private List<Chunk> toEntityList(List<NLPNode> nodes, JsonNode json) {
        if (json == null) {
            return null;
        }
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (JsonNode node : json) {
            Iterator it = node.iterator();
            int begin = ((JsonNode)it.next()).asInt();
            int end = ((JsonNode)it.next()).asInt();
            String label = ((JsonNode)it.next()).asText();
            Chunk chunk = new Chunk();
            chunk.setNodes(IntStream.range(begin, end).mapToObj(nodes::get).collect(Collectors.toList()));
            chunk.setLabel(label);
            chunks.add(chunk);
        }
        return chunks;
    }

    private void setPrimaryDependencies(Sentence sentence, JsonNode json) {
        if (json == null) {
            return;
        }
        List<NLPNode> nodes = sentence.getNodes();
        int i = 0;
        for (JsonNode node : json) {
            Iterator it = node.iterator();
            int head_id = ((JsonNode)it.next()).asInt();
            NLPNode head = head_id < 0 ? sentence.getRoot() : nodes.get(head_id);
            String label = ((JsonNode)it.next()).asText();
            nodes.get(i++).setParent(head, label);
        }
    }

    public List<Sentence> get() {
        return this.sentences;
    }

    public void set(List<Sentence> sentences) {
        this.sentences = sentences;
    }

    public int size() {
        return this.sentences.size();
    }

    public Sentence get(int index) {
        return this.sentences.get(index);
    }

    public boolean add(Sentence sentence) {
        return this.sentences.add(sentence);
    }

    public void add(int index, Sentence sentence) {
        this.sentences.add(index, sentence);
    }

    public Sentence set(int index, Sentence sentence) {
        return this.sentences.set(index, sentence);
    }

    public Sentence remove(int index) {
        return this.sentences.remove(index);
    }

    public boolean remove(Sentence sentence) {
        return this.sentences.remove(sentence);
    }

    @Override
    public Iterator<Sentence> iterator() {
        return this.sentences.iterator();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(",\n");
        for (Sentence s : this.sentences) {
            joiner.add(s.toString());
        }
        return "[" + joiner.toString() + "]";
    }
}

