/*
 * Decompiled with CFR 0.152.
 */
package cloud.elit.sdk.nlp.structure;

import cloud.elit.sdk.nlp.structure.Arc;
import cloud.elit.sdk.nlp.structure.Chunk;
import cloud.elit.sdk.nlp.structure.Offset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Sentence {
    private Map<String, Object> field_map;

    public Sentence() {
        this.field_map = new HashMap<String, Object>();
    }

    public Sentence(Sentence sentence) {
        this.field_map = new HashMap<String, Object>(sentence.field_map);
    }

    public Sentence(List<String> tokens) {
        this();
        this.setTokens(tokens);
    }

    public <V> V getFields(String field) {
        return (V)this.field_map.get(field);
    }

    public <V> void setFields(String field, V values) {
        this.field_map.put(field, values);
    }

    public List<String> getTokens() {
        return (List)this.getFields("tok");
    }

    public void setTokens(List<String> tokens) {
        this.setFields("tok", tokens);
    }

    public List<Offset> getOffsets() {
        return (List)this.getFields("off");
    }

    public void setOffsets(List<Offset> offsets) {
        this.setFields("off", offsets);
    }

    public List<String> getLemmas() {
        return (List)this.getFields("lem");
    }

    public void setLemmas(List<String> lemmas) {
        this.setFields("lem", lemmas);
    }

    public List<String> getPartOfSpeechTags() {
        return (List)this.getFields("pos");
    }

    public void setPartOfSpeechTags(List<String> tags) {
        this.setFields("pos", tags);
    }

    public List<Chunk> getNamedEntityTags() {
        return (List)this.getFields("ner");
    }

    public void setNamedEntityTags(List<Chunk> tags) {
        this.setFields("ner", tags);
    }

    public List<Arc> getDependencyRelations() {
        return (List)this.getFields("dep");
    }

    public void setDependencyRelations(List<Arc> arcs) {
        this.setFields("dep", arcs);
    }
}

