/*
 * Copyright 2018 Emory University
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cloud.elit.sdk.nlp.structure;

public class Offset {
    private int begin;
    private int end;

    // ============================ Constructors ============================

    /**
     * @param begin the beginning index of the span (inclusive).
     * @param end the ending index of the span (exclusive).
     */
    public Offset(int begin, int end) {
        setBegin(begin);
        setEnd(end);
    }

    public Offset() {
        this(-1, -1);
    }

    // ============================ Getters and Setters ============================

    public int getBegin() {
        return begin;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public int getEnd() {
        return end;
    }

    public void setEnd(int end) {
        this.end = end;
    }
}
