/*
 * Decompiled with CFR 0.152.
 */
package cloud.elit.nlp.component.token;

import cloud.elit.nlp.component.token.SimpleTokenizerParameters;
import cloud.elit.sdk.nlp.component.Tokenizer;
import cloud.elit.sdk.nlp.structure.Document;
import cloud.elit.sdk.nlp.structure.Sentence;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SimpleTokenizer
extends Tokenizer<SimpleTokenizerParameters> {
    private Pattern DELIM = Pattern.compile("\\s+");

    public void load(String model_path, SimpleTokenizerParameters params) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(model_path + "/" + params.getModelName()));
            int i = 0;
            while ((line = reader.readLine()) != null) {
                if (i == params.getChoice()) {
                    this.DELIM = Pattern.compile(line.trim());
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Document decode(String input, SimpleTokenizerParameters params) {
        String[] tokens = this.DELIM.split(input);
        Document document = new Document();
        int begin = 0;
        for (int end = 0; end < tokens.length; ++end) {
            String token = tokens[end];
            if (!token.endsWith(".") && !token.endsWith("?") && !token.endsWith("!")) continue;
            List t = IntStream.range(begin, end + 1).mapToObj(j -> tokens[j]).collect(Collectors.toList());
            document.addSentence(new Sentence(this.getSubList(tokens, begin, end + 1)));
            begin = end + 1;
        }
        if (begin < tokens.length) {
            document.addSentence(new Sentence(this.getSubList(tokens, begin, tokens.length)));
        }
        return document;
    }

    public void save(String model_path, SimpleTokenizerParameters params) {
        throw new UnsupportedOperationException();
    }

    public void train(List<String> trn_data, List<String> dev_data, SimpleTokenizerParameters params) {
        throw new UnsupportedOperationException();
    }

    private List<String> getSubList(String[] array, int begin, int end) {
        return IntStream.range(begin, end).mapToObj(i -> array[i]).collect(Collectors.toList());
    }
}

