/*
 * Decompiled with CFR 0.152.
 */
package configs.cloud.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import configs.cloud.client.entity.Config;
import configs.cloud.client.entity.Dataset;
import configs.cloud.client.entity.Env;
import configs.cloud.client.entity.EnvReturnFormat;
import configs.cloud.client.exceptions.ForbiddenException;
import configs.cloud.client.exceptions.NotFoundException;
import configs.cloud.client.exceptions.UnAuthorizedException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudConfigClient {
    private Logger logger = LoggerFactory.getLogger(CloudConfigClient.class);
    private String apiKey;
    private String url;

    public CloudConfigClient(String apiKey, String url) {
        this.apiKey = apiKey;
        this.url = url;
    }

    public List<Config> getAllConfiguration(Integer datasetId) {
        List<Config> configs = new ArrayList<Config>(0);
        try {
            Client client = Client.create();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("datasetid", String.valueOf(datasetId));
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            WebResource.Builder webResource = client.resource(this.replaceParametersOnURL(this.url + "/api/configs/{datasetid}", parameters).toASCIIString()).queryParams((MultivaluedMap)queryParams).header("X-Auth-Token", (Object)this.apiKey);
            ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).get(ClientResponse.class);
            Config[] config = (Config[])this.parseResponse(response, Config[].class);
            if (config.length > 0) {
                configs = Arrays.asList(config);
            }
        }
        catch (Exception e) {
            this.logger.error("Error occurred while getting configuration.", (Throwable)e);
        }
        return configs;
    }

    public List<Config> getAllConfigurationForEnvironment(Integer datasetId, String envsname) {
        List<Config> configs = new ArrayList<Config>(0);
        try {
            Client client = Client.create();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("datasetid", String.valueOf(datasetId));
            parameters.put("envsname", envsname);
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            WebResource.Builder webResource = client.resource(this.replaceParametersOnURL(this.url + "/api/configs/{datasetid}/{envsname}", parameters).toASCIIString()).queryParams((MultivaluedMap)queryParams).header("X-Auth-Token", (Object)this.apiKey);
            ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).get(ClientResponse.class);
            Config[] config = (Config[])this.parseResponse(response, Config[].class);
            if (config.length > 0) {
                configs = Arrays.asList(config);
            }
        }
        catch (Exception e) {
            this.logger.error("Error occurred while getting configuration for environment.", (Throwable)e);
        }
        return configs;
    }

    public List<Config> getConfigurationByDatasetAndEnvironmentAndKey(Integer datasetId, String envsname, String key) {
        List<Config> configs = new ArrayList<Config>(0);
        try {
            Client client = Client.create();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("datasetid", String.valueOf(datasetId));
            parameters.put("envsname", envsname);
            parameters.put("key", key);
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            WebResource.Builder webResource = client.resource(this.replaceParametersOnURL(this.url + "/api/configs/{datasetid}/{envsname}/{key}", parameters).toASCIIString()).queryParams((MultivaluedMap)queryParams).header("X-Auth-Token", (Object)this.apiKey);
            ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).get(ClientResponse.class);
            Config[] config = (Config[])this.parseResponse(response, Config[].class);
            if (config.length > 0) {
                configs = Arrays.asList(config);
            }
        }
        catch (Exception e) {
            this.logger.error("Error occurred while getting configuration by dataset,environment and key.", (Throwable)e);
        }
        return configs;
    }

    public void updateConfigKey(Integer datasetId, String envsname, String key, String value) {
        try {
            Client client = Client.create();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("datasetid", String.valueOf(datasetId));
            parameters.put("envsname", envsname);
            parameters.put("key", key);
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            queryParams.add((Object)"value", (Object)value);
            WebResource.Builder webResource = client.resource(this.replaceParametersOnURL(this.url + "/api/configs/{datasetid}/{envsname}/{key}", parameters).toASCIIString()).queryParams((MultivaluedMap)queryParams).header("X-Auth-Token", (Object)this.apiKey);
            ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).put(ClientResponse.class);
            if (response.getStatus() != 200 && response.getStatus() != 201) {
                if (response.getStatus() == 401) {
                    throw new UnAuthorizedException("UnAuthorized");
                }
                if (response.getStatus() == 403) {
                    throw new ForbiddenException("Access denied");
                }
                if (response.getStatus() == 404) {
                    throw new NotFoundException("Resource requested was not found on the server");
                }
                throw new RuntimeException("Internal server error ");
            }
            response.getStatus();
        }
        catch (Exception e) {
            this.logger.error("Error occurred while updating configuration key.", (Throwable)e);
        }
    }

    public void updateConfigEnabledStatusForEnv(Integer datasetId, String envsname, String key, String isenabled) {
        try {
            Client client = Client.create();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("datasetid", String.valueOf(datasetId));
            parameters.put("envsname", envsname);
            parameters.put("key", key);
            parameters.put("isenabled", isenabled);
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            WebResource.Builder webResource = client.resource(this.replaceParametersOnURL(this.url + "/api/configs/{datasetid}/{envsname}/{key}/{isenabled}", parameters).toASCIIString()).queryParams((MultivaluedMap)queryParams).header("X-Auth-Token", (Object)this.apiKey);
            ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).put(ClientResponse.class);
            if (response.getStatus() != 200 && response.getStatus() != 201) {
                if (response.getStatus() == 401) {
                    throw new UnAuthorizedException("UnAuthorized");
                }
                if (response.getStatus() == 403) {
                    throw new ForbiddenException("Access denied");
                }
                if (response.getStatus() == 404) {
                    throw new NotFoundException("Resource requested was not found on the server");
                }
                throw new RuntimeException("Internal server error ");
            }
            response.getStatus();
        }
        catch (Exception e) {
            this.logger.error("Error occurred while updating configuration status.", (Throwable)e);
        }
    }

    public List<Dataset> getAllDataset() {
        List<Dataset> datasets = new ArrayList<Dataset>(0);
        try {
            Client client = Client.create();
            HashMap<String, String> parameters = new HashMap<String, String>();
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            WebResource.Builder webResource = client.resource(this.replaceParametersOnURL(this.url + "/api/dataset/all", parameters).toASCIIString()).queryParams((MultivaluedMap)queryParams).header("X-Auth-Token", (Object)this.apiKey);
            ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).get(ClientResponse.class);
            Dataset[] dataset = (Dataset[])this.parseResponse(response, Dataset[].class);
            if (dataset.length > 0) {
                datasets = Arrays.asList(dataset);
            }
        }
        catch (Exception e) {
            this.logger.error("Error occurred while getting datasets.", (Throwable)e);
        }
        return datasets;
    }

    public List<Dataset> getDatasetByDatasetId(Integer datasetId) {
        List<Dataset> datasets = new ArrayList<Dataset>(0);
        try {
            Client client = Client.create();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("datasetid", String.valueOf(datasetId));
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            WebResource.Builder webResource = client.resource(this.replaceParametersOnURL(this.url + "/api/dataset/{datasetid}", parameters).toASCIIString()).queryParams((MultivaluedMap)queryParams).header("X-Auth-Token", (Object)this.apiKey);
            ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).get(ClientResponse.class);
            Dataset[] dataset = (Dataset[])this.parseResponse(response, Dataset[].class);
            if (dataset.length > 0) {
                datasets = Arrays.asList(dataset);
            }
        }
        catch (Exception e) {
            this.logger.error("Error occurred while getting dataset by id.", (Throwable)e);
        }
        return datasets;
    }

    public EnvReturnFormat getAllEnvironment() {
        EnvReturnFormat environments = new EnvReturnFormat();
        try {
            Client client = Client.create();
            HashMap<String, String> parameters = new HashMap<String, String>();
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            WebResource.Builder webResource = client.resource(this.replaceParametersOnURL(this.url + "/api/env", parameters).toASCIIString()).queryParams((MultivaluedMap)queryParams).header("X-Auth-Token", (Object)this.apiKey);
            ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).get(ClientResponse.class);
            environments = (EnvReturnFormat)this.parseResponse(response, EnvReturnFormat.class);
        }
        catch (Exception e) {
            this.logger.error("Error occurred while getting environment.", (Throwable)e);
        }
        return environments;
    }

    public Env getEnvironmentByShortName(String sname) {
        Env environment = new Env();
        try {
            Client client = Client.create();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("envsname", sname);
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            WebResource.Builder webResource = client.resource(this.replaceParametersOnURL(this.url + "/api/env/{envsname}", parameters).toASCIIString()).queryParams((MultivaluedMap)queryParams).header("X-Auth-Token", (Object)this.apiKey);
            ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).get(ClientResponse.class);
            environment = (Env)this.parseResponse(response, Env.class);
        }
        catch (Exception e) {
            this.logger.error("Error occurred while getting environment by shortname.", (Throwable)e);
        }
        return environment;
    }

    public List<Config> getConfigByRSQLSearch(String search) {
        List<Config> configs = new ArrayList<Config>(0);
        try {
            Client client = Client.create();
            HashMap<String, String> parameters = new HashMap<String, String>();
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            queryParams.add((Object)"search", (Object)search);
            WebResource.Builder webResource = client.resource(this.replaceParametersOnURL(this.url + "/api/configs/parser", parameters).toASCIIString()).queryParams((MultivaluedMap)queryParams).header("X-Auth-Token", (Object)this.apiKey);
            ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).get(ClientResponse.class);
            Config[] config = (Config[])this.parseResponse(response, Config[].class);
            if (config.length > 0) {
                configs = Arrays.asList(config);
            }
        }
        catch (Exception e) {
            this.logger.error("Error occurred while getting configuration", (Throwable)e);
        }
        return configs;
    }

    public List<Config> getConfigByRSQLSearch(String search, String iqk) {
        List<Config> configs = new ArrayList<Config>(0);
        try {
            Client client = Client.create();
            HashMap<String, String> parameters = new HashMap<String, String>();
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            queryParams.add((Object)"search", (Object)search);
            queryParams.add((Object)"iqk", (Object)iqk);
            WebResource.Builder webResource = client.resource(this.replaceParametersOnURL(this.url + "/api/configs/parser", parameters).toASCIIString()).queryParams((MultivaluedMap)queryParams).header("X-Auth-Token", (Object)this.apiKey);
            ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).get(ClientResponse.class);
            Config[] config = (Config[])this.parseResponse(response, Config[].class);
            if (config.length > 0) {
                configs = Arrays.asList(config);
            }
        }
        catch (Exception e) {
            this.logger.error("Error occurred while getting configuration", (Throwable)e);
        }
        return configs;
    }

    private Object parseResponse(ClientResponse response, Class<?> clazz) throws Exception {
        if (response.getStatus() == 200) {
            ObjectMapper mapper = new ObjectMapper();
            String output = (String)response.getEntity(String.class);
            return mapper.readValue(output, clazz);
        }
        if (response.getStatus() == 401) {
            throw new UnAuthorizedException("UnAuthorized");
        }
        if (response.getStatus() == 403) {
            throw new ForbiddenException("Access denied");
        }
        if (response.getStatus() == 404) {
            throw new NotFoundException("Resource requested was not found on the server");
        }
        throw new RuntimeException("Internal server error");
    }

    private URI replaceParametersOnURL(String template, Map<String, String> parameters) {
        UriBuilder builder = UriBuilder.fromPath((String)template);
        URI output = builder.buildFromMap(parameters);
        return output;
    }
}

