/*
 * Decompiled with CFR 0.152.
 */
package cloud.cirrusup;

import cloud.cirrusup.S3PropertySource;
import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;

public class S3PropertySourcesPlaceholderConfigurer
extends PropertySourcesPlaceholderConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(S3PropertySourcesPlaceholderConfigurer.class);
    private final AmazonS3 amazonS3;
    private final String bucket;
    private final String fileName;

    public S3PropertySourcesPlaceholderConfigurer(AmazonS3 amazonS3, String bucket, String fileName) {
        Preconditions.checkNotNull((Object)amazonS3, (Object)"AWS S3 client cannot be null.");
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)bucket), (Object)"Bucket cannot be null or empty.");
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)fileName), (Object)"File name cannot be null or empty.");
        this.amazonS3 = amazonS3;
        this.bucket = bucket;
        this.fileName = fileName;
    }

    public void postProcessBeanFactory(@NotNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        try {
            LOG.info("Loading properties from S3 {} bucket, file {}.", (Object)this.bucket, (Object)this.fileName);
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(this.getObjectContentFromS3()));
            S3PropertySource s3PropertySource = new S3PropertySource(properties);
            MutablePropertySources sources = new MutablePropertySources();
            sources.addLast((PropertySource)s3PropertySource);
            this.setPropertySources((PropertySources)sources);
            super.postProcessBeanFactory(beanFactory);
            LOG.info("Successfully loaded properties from S3.");
        }
        catch (IOException e) {
            LOG.warn("Exception on loading properties from S3 ", (Throwable)e);
            Throwables.propagate((Throwable)e);
        }
    }

    private byte[] getObjectContentFromS3() throws IOException {
        S3Object object = null;
        try {
            GetObjectRequest request = new GetObjectRequest(this.bucket, this.fileName);
            object = this.amazonS3.getObject(request);
            byte[] byArray = IOUtils.toByteArray((InputStream)object.getObjectContent());
            return byArray;
        }
        catch (AmazonS3Exception e) {
            if (e.getErrorCode().equals("NoSuchBucket")) {
                throw new IOException("Bucket doesn't exist.");
            }
            if (e.getErrorCode().equals("NoSuchKey")) {
                throw new IOException("Document with key " + this.fileName + " not found.");
            }
            throw new IOException(e);
        }
        catch (AmazonClientException e) {
            throw new IOException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)object.getObjectContent());
        }
    }
}

