/*
 * Decompiled with CFR 0.152.
 */
package com.cirrustech.utils;

import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JSONUtils.class);
    private static final Gson GSON = new Gson();

    private JSONUtils() {
    }

    public static String encodeToJSON(MetricDatum metricDatum) {
        Preconditions.checkNotNull((Object)metricDatum, (Object)"Argument cannot be null.");
        return GSON.toJson((Object)metricDatum);
    }

    public static MetricDatum decodeJSON(String json) {
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)json), (Object)"Value cannot be null or empty.");
        try {
            return (MetricDatum)GSON.fromJson(json, MetricDatum.class);
        }
        catch (Exception e) {
            LOG.info("Exception on converting input {} {}", (Object)json, (Object)e);
            return null;
        }
    }
}

