/*
 * Decompiled with CFR 0.152.
 */
package com.cirrustech.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class FileUtils {
    private static final String TIME_ROLLING_LOG_FILE_SUFFIX = "/metrics-logs-%s.log";
    private static final String PROPERTIES_FILE_EXTENSION = ".properties";
    private static final String EXTENSION_SEPARATOR = ".";
    private static final SimpleDateFormat TEMPLATE = new SimpleDateFormat("yyyy-MM-dd-HH");
    private static final Pattern TIME_ROLLING_LOG_FILE_PATTERN = Pattern.compile("metrics-logs-\\d{4}-\\d{1,2}-\\d{1,2}-\\d{1,2}.log\\z");

    private FileUtils() {
    }

    public static String generateLogFileTimeRollingSuffix() {
        return String.format(TIME_ROLLING_LOG_FILE_SUFFIX, TEMPLATE.format(new Date()));
    }

    public static String generatePropertiesFileNameForLogFile(String logFile) {
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)logFile), (Object)"Log file name cannot be null or empty.");
        int extensionSeparator = logFile.lastIndexOf(EXTENSION_SEPARATOR);
        String fileName = logFile.substring(0, extensionSeparator);
        return fileName + PROPERTIES_FILE_EXTENSION;
    }

    public static boolean isLogFile(File file) {
        return TIME_ROLLING_LOG_FILE_PATTERN.matcher(file.getName()).find();
    }

    public static String validatePath(String filePath) {
        File file = new File(filePath);
        if (!filePath.endsWith("/")) {
            filePath = filePath + "/";
        }
        if (!file.exists()) {
            file.mkdir();
        } else if (!file.isDirectory()) {
            throw new IllegalArgumentException("Invalid path: it must point to a directory, not a file.");
        }
        return filePath;
    }
}

