/*
 * Decompiled with CFR 0.152.
 */
package com.cirrustech.publisher.callable;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

class PropertiesFileHandler {
    private static final String BYTES_READ = "bytesRead";
    private static final String LAST_UPDATE = "lastUpdate";
    private final File fileHandler;
    private final Properties properties;

    PropertiesFileHandler(String fileName) throws IOException {
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)fileName), (Object)"File name cannot be null or empty.");
        this.fileHandler = new File(fileName);
        this.properties = new Properties();
        if (this.propertiesFileExists()) {
            this.loadProperties();
        }
    }

    private void loadProperties() throws IOException {
        try (FileInputStream input = new FileInputStream(this.fileHandler);){
            this.properties.load(input);
        }
    }

    private void saveProperties() throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(this.fileHandler);){
            this.properties.store(outputStream, "");
        }
    }

    void updateRecords(int bytesRead) throws IOException {
        this.properties.setProperty(BYTES_READ, String.valueOf(this.getBytesRead() + bytesRead));
        this.properties.setProperty(LAST_UPDATE, String.valueOf(System.currentTimeMillis()));
        this.saveProperties();
    }

    boolean propertiesFileExists() {
        return this.fileHandler.exists() && this.fileHandler.isFile();
    }

    int getBytesRead() {
        if (!this.properties.containsKey(BYTES_READ)) {
            return 0;
        }
        return Integer.valueOf(this.properties.getProperty(BYTES_READ));
    }

    long getLastUpdateTimestamp() {
        if (!this.properties.containsKey(LAST_UPDATE)) {
            return 0L;
        }
        return Long.valueOf(this.properties.getProperty(LAST_UPDATE));
    }

    void delete() {
        this.fileHandler.delete();
        this.properties.clear();
    }
}

