/*
 * Decompiled with CFR 0.152.
 */
package com.cirrustech.publisher;

import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.cirrustech.publisher.MetricsPublisher;
import com.cirrustech.publisher.callable.FileBasedCallable;
import com.cirrustech.utils.FileUtils;
import com.cirrustech.utils.JSONUtils;
import com.google.common.base.Preconditions;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;

public class FileBasedMetricsPublisher
implements MetricsPublisher {
    private final String filePath;
    private final ExecutorService logsPublisher;

    public FileBasedMetricsPublisher(AmazonCloudWatch client, String filePath, String namespace, int millisBetweenRun) {
        Preconditions.checkNotNull((Object)client, (Object)"AWS client cannot be null.");
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)filePath), (Object)"File path cannot be null or empty.");
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)namespace), (Object)"Namespace cannot be null or empty.");
        Preconditions.checkArgument((millisBetweenRun > 0 ? 1 : 0) != 0, (Object)"Wait time interval cannot be negative.");
        FileUtils.validatePath(filePath);
        this.filePath = filePath;
        this.logsPublisher = Executors.newSingleThreadExecutor();
        this.logsPublisher.submit(new FileBasedCallable(client, filePath, namespace, millisBetweenRun));
    }

    public FileBasedMetricsPublisher(AmazonCloudWatch client, String filePath, String namespace, int millisBetweenRun, int logsRetentionPeriodMillis) {
        Preconditions.checkNotNull((Object)client, (Object)"AWS client cannot be null.");
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)filePath), (Object)"File path cannot be null or empty.");
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)namespace), (Object)"Namespace cannot be null or empty.");
        Preconditions.checkArgument((millisBetweenRun > 0 ? 1 : 0) != 0, (Object)"Wait time interval cannot be negative.");
        Preconditions.checkArgument((logsRetentionPeriodMillis > 0 ? 1 : 0) != 0, (Object)"Retention period interval cannot be negative.");
        FileUtils.validatePath(filePath);
        this.filePath = filePath;
        this.logsPublisher = Executors.newSingleThreadExecutor();
        FileBasedCallable task = new FileBasedCallable(client, filePath, namespace, millisBetweenRun);
        task.setMaxTimeToKeepFilesInMillis(logsRetentionPeriodMillis);
        this.logsPublisher.submit(task);
    }

    @Override
    public void publish(Collection<MetricDatum> metrics) throws IOException {
        if (this.logsPublisher.isShutdown()) {
            throw new IOException("Publisher channel is closed.");
        }
        String fullFilePath = this.filePath + FileUtils.generateLogFileTimeRollingSuffix();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(fullFilePath, true));){
            for (MetricDatum datum : metrics) {
                bw.write(JSONUtils.encodeToJSON(datum));
                bw.newLine();
            }
        }
        catch (IOException e) {
            throw new IOException("Exception on writing to file: " + e);
        }
    }

    @Override
    public void closePublisher() {
        this.logsPublisher.shutdown();
    }
}

