/*
 * Decompiled with CFR 0.152.
 */
package com.cirrustech.metric;

import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.cirrustech.metric.Metric;
import com.cirrustech.publisher.MetricsPublisher;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSCloudWatchMetric
implements Metric {
    private static final Logger LOG = LoggerFactory.getLogger(AWSCloudWatchMetric.class);
    private final MetricsPublisher publisher;
    private final String metricName;
    private List<MetricDatum> measureList = Lists.newArrayList();
    private long openTimestamp;

    public AWSCloudWatchMetric(MetricsPublisher publisher, String name) {
        Preconditions.checkNotNull((Object)publisher, (Object)"Metrics publisher cannot be null.");
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)name), (Object)"Metrics name cannot be null or empty");
        this.publisher = publisher;
        this.metricName = name;
        this.measureList = Lists.newArrayList();
    }

    @Override
    public void open() {
        this.openTimestamp = System.currentTimeMillis();
    }

    @Override
    public void close() {
        Preconditions.checkArgument((this.openTimestamp > 0L ? 1 : 0) != 0, (Object)"Missing open() call.");
        try {
            MetricDatum totalTime = new MetricDatum().withMetricName(this.metricName + ".Duration").withValue(Double.valueOf(System.currentTimeMillis() - this.openTimestamp)).withUnit(StandardUnit.Milliseconds).withTimestamp(new Date(System.currentTimeMillis()));
            this.measureList.add(totalTime);
            this.publisher.publish(this.measureList);
            this.resetMeasures();
        }
        catch (Exception e) {
            LOG.info("Exception on publishing utils into AWS CloudWatch {}", (Throwable)e);
        }
    }

    @Override
    public void addMeasure(String name, double value) {
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)name), (Object)"Measure name cannot be null or empty.");
        Preconditions.checkArgument((this.openTimestamp > 0L ? 1 : 0) != 0, (Object)"Missing open() call.");
        this.measureList.add(new MetricDatum().withMetricName(this.metricName + "." + name).withValue(Double.valueOf(value)).withUnit(StandardUnit.Count).withTimestamp(new Date(System.currentTimeMillis())));
    }

    @Override
    public void resetMeasures() {
        this.measureList.clear();
    }
}

