/*
 * Decompiled with CFR 0.152.
 */
package com.cirrustech.publisher.callable;

import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueBasedCallable
implements Callable {
    private static final Logger LOG = LoggerFactory.getLogger(QueueBasedCallable.class);
    private static final int MAX_ITEMS_PER_BATCH = 18;
    private final BlockingQueue<MetricDatum> metricsQueue;
    private final AmazonCloudWatch client;
    private final int maxMillisToWait;
    private final String namespace;

    public QueueBasedCallable(BlockingQueue<MetricDatum> metricsQueue, AmazonCloudWatch client, String namespace, int maxMillisToWait) {
        Preconditions.checkNotNull(metricsQueue, (Object)"Queue cannot be null.");
        Preconditions.checkNotNull((Object)client, (Object)"AWS client cannot be null.");
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)namespace), (Object)"Namespace cannot be null or empty.");
        Preconditions.checkArgument((maxMillisToWait > 0 ? 1 : 0) != 0, (Object)"Wait time cannot be negative.");
        this.metricsQueue = metricsQueue;
        this.client = client;
        this.maxMillisToWait = maxMillisToWait;
        this.namespace = namespace;
    }

    public Object call() throws Exception {
        while (true) {
            try {
                while (true) {
                    long now = System.currentTimeMillis();
                    ArrayList list = Lists.newArrayList();
                    while (list.size() < 18 && System.currentTimeMillis() - now < (long)this.maxMillisToWait) {
                        MetricDatum poll = this.metricsQueue.poll(this.maxMillisToWait, TimeUnit.MILLISECONDS);
                        if (poll == null) continue;
                        list.add(poll);
                    }
                    if (list.isEmpty()) continue;
                    PutMetricDataRequest request = new PutMetricDataRequest().withNamespace(this.namespace).withMetricData((Collection)list);
                    this.client.putMetricData(request);
                }
            }
            catch (Exception e) {
                LOG.warn(e.getMessage());
                continue;
            }
            break;
        }
    }
}

