/*
 * Decompiled with CFR 0.152.
 */
package com.cirrustech.publisher;

import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.cirrustech.publisher.MetricsPublisher;
import com.cirrustech.publisher.callable.QueueBasedCallable;
import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueBasedMetricsPublisher
implements MetricsPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(QueueBasedMetricsPublisher.class);
    private final BlockingQueue<MetricDatum> metricsQueue;
    private final ExecutorService logsPublisher;

    public QueueBasedMetricsPublisher(AmazonCloudWatch client, String namespace, int maxMillisToWait) {
        Preconditions.checkNotNull((Object)client, (Object)"AWS client cannot be null.");
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)namespace), (Object)"Namespace cannot be null or empty");
        Preconditions.checkArgument((maxMillisToWait > 0 ? 1 : 0) != 0, (Object)"Wait time interval cannot be negative.");
        this.metricsQueue = Queues.newLinkedBlockingQueue();
        this.logsPublisher = Executors.newSingleThreadExecutor();
        this.logsPublisher.submit(new QueueBasedCallable(this.metricsQueue, client, namespace, maxMillisToWait));
    }

    @Override
    public void publish(Collection<MetricDatum> metrics) throws IOException {
        Preconditions.checkNotNull(metrics, (Object)"Metrics list cannot be null");
        if (this.logsPublisher.isShutdown()) {
            throw new IOException("Publisher channel is closed.");
        }
        for (MetricDatum measure : metrics) {
            try {
                this.metricsQueue.put(measure);
                LOG.info("Published {} metrics to the queue. ", (Object)metrics.size());
            }
            catch (Exception e) {
                throw new IOException("Exception on adding item to queue.");
            }
        }
    }

    @Override
    public void closePublisher() {
        this.logsPublisher.shutdown();
    }
}

