package com.cirrustech.metric.factory;

import com.cirrustech.metric.AWSCloudWatchMetric;
import com.cirrustech.metric.Metric;
import com.cirrustech.publisher.MetricsPublisher;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

/**
 * Implementation of {@link MetricsFactory} using AWS CloudWatch.
 */
public class AWSCloudWatchMetricsFactory implements MetricsFactory {

    /**
     * Metrics publisher
     */
    private final MetricsPublisher metricsPublisher;

    /**
     * Constructor.
     *
     * @param metricsPublisher metrics publisher
     */
    public AWSCloudWatchMetricsFactory(MetricsPublisher metricsPublisher) {

        Preconditions.checkNotNull(metricsPublisher, "Metrics publisher cannot be null or empty");

        this.metricsPublisher = metricsPublisher;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Metric newMetric(String name) {

        Preconditions.checkNotNull(StringUtils.trimToNull(name), "Metrics name cannot be null or empty.");

        return new AWSCloudWatchMetric(name, metricsPublisher);
    }
}
