/*
 * Decompiled with CFR 0.152.
 */
package cloud.cirrusup.publisher;

import cloud.cirrusup.publisher.Publisher;
import cloud.cirrusup.publisher.model.PublishedInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainLogPublisher
implements Publisher {
    private static final Logger LOG = LoggerFactory.getLogger((String)"aws-latency-log");

    @Override
    public void publish(PublishedInfo info) {
        LOG.info("Request ID [{}] to [{}/{}] took [{}] milliseconds and returned the RESPONSE_CODE [{}]", new Object[]{info.getInfo("requestId"), info.getInfo("serviceName"), info.getInfo("httpMethod"), info.getLatency(), info.getStatusCode()});
        if (info.hasInfo("errorInfo")) {
            LOG.warn("Request ID [{}], RESPONSE_CODE [{}], MESSAGE [{}]", new Object[]{info.getInfo("requestId"), info.getStatusCode(), info.getInfo("errorInfo")});
        }
        if (info.hasInfo("apiMethod")) {
            LOG.info("Request ID [{}], API method [{}]", (Object)info.getInfo("requestId"), (Object)info.getInfo("apiMethod"));
        }
    }
}

