/*
 * Decompiled with CFR 0.152.
 */
package cloud.cirrusup.publisher;

import cloud.cirrusup.publisher.Publisher;
import cloud.cirrusup.publisher.model.PublishedInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONPublisher
implements Publisher {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger((String)"aws-latency-log");

    @Override
    public void publish(PublishedInfo info) {
        ObjectNode node = mapper.createObjectNode();
        node.put("requestId", info.getInfo("requestId"));
        node.put("serviceName", info.getInfo("serviceName"));
        node.put("httpMethod", info.getInfo("httpMethod"));
        node.put("latency", info.getLatency());
        node.put("statusCode", info.getStatusCode());
        if (info.hasInfo("errorInfo")) {
            node.put("errorMessage", info.getInfo("errorInfo"));
        }
        if (info.hasInfo("apiMethod")) {
            node.put("apiMethod", info.getInfo("apiMethod"));
        }
        try {
            LOG.info(mapper.writeValueAsString((Object)node));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }
}

