/*
 * Decompiled with CFR 0.152.
 */
package cloud.cirrusup;

import cloud.cirrusup.RandomGenerator;
import cloud.cirrusup.publisher.PlainLogPublisher;
import cloud.cirrusup.publisher.Publisher;
import cloud.cirrusup.publisher.model.PublishedInfo;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class AwsLatencyRequestLogHandler
extends RequestHandler2 {
    private static final String REQUEST_ID = "requestId";
    private final Publisher publisher;
    private final ConcurrentHashMap<String, Long> REQUEST_MAP = new ConcurrentHashMap();

    public AwsLatencyRequestLogHandler() {
        this(new PlainLogPublisher());
    }

    public AwsLatencyRequestLogHandler(Publisher publisher) {
        this.publisher = publisher;
    }

    public void beforeRequest(Request<?> request) {
        String id = RandomGenerator.getUUIDRandomString();
        request.getHeaders().put(REQUEST_ID, id);
        this.REQUEST_MAP.put(id, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterResponse(Request<?> request, Response<?> response) {
        String id = (String)request.getHeaders().get(REQUEST_ID);
        PublishedInfo info = new PublishedInfo();
        try {
            info.addInfo("serviceName", request.getServiceName());
            info.addInfo("httpMethod", request.getHttpMethod().name());
            info.addInfo("apiMethod", this.getApiMethod(request));
            info.addInfo(REQUEST_ID, this.getRequestId(request, response));
            info.addLatency(this.getTime(id));
            info.setStatusCode(this.getStatusCode(response, null));
        }
        catch (Exception exception) {
        }
        finally {
            this.publisher.publish(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterError(Request<?> request, Response<?> response, Exception e) {
        String id = (String)request.getHeaders().get(REQUEST_ID);
        PublishedInfo info = new PublishedInfo();
        try {
            info.addInfo("serviceName", request.getServiceName());
            info.addInfo("httpMethod", request.getHttpMethod().name());
            info.addInfo(REQUEST_ID, this.getRequestId(e));
            info.addInfo("apiMethod", this.getApiMethod(request));
            info.addInfo("errorInfo", e.getMessage());
            info.addLatency(this.getTime(id));
            info.setStatusCode(this.getStatusCode(response, e));
        }
        catch (Exception exception) {
        }
        finally {
            this.publisher.publish(info);
        }
    }

    private String getApiMethod(Request<?> request) {
        List action;
        if (request != null && request.getHeaders() != null && request.getHeaders().containsKey("X-Amz-Target")) {
            return (String)request.getHeaders().get("X-Amz-Target");
        }
        if (request != null && request.getParameters() != null && request.getParameters().containsKey("Action") && !(action = (List)request.getParameters().get("Action")).isEmpty()) {
            return (String)action.get(0);
        }
        return null;
    }

    private String getRequestId(Exception e) {
        if (e != null && e instanceof AmazonServiceException) {
            AmazonServiceException awsException = (AmazonServiceException)e;
            if (awsException.getServiceName().equals("Amazon S3") && awsException instanceof AmazonS3Exception) {
                return awsException.getRequestId() + " " + ((AmazonS3Exception)e).getExtendedRequestId();
            }
            return awsException.getRequestId();
        }
        return null;
    }

    private String getRequestId(Request<?> request, Response<?> response) {
        if (response != null && response.getHttpResponse() != null && response.getHttpResponse().getHeaders() != null) {
            if (request.getServiceName().equals("Amazon S3")) {
                return (String)response.getHttpResponse().getHeaders().get("x-amz-request-id") + " " + (String)response.getHttpResponse().getHeaders().get("x-amz-id-2");
            }
            return (String)response.getHttpResponse().getHeaders().get("x-amzn-RequestId");
        }
        return null;
    }

    private int getStatusCode(Response<?> response, Exception e) {
        if (response != null && response.getHttpResponse() != null) {
            return response.getHttpResponse().getStatusCode();
        }
        if (e != null && e instanceof AmazonServiceException) {
            return ((AmazonServiceException)e).getStatusCode();
        }
        return -1;
    }

    private long getTime(String id) throws Exception {
        Long time = this.REQUEST_MAP.get(id);
        if (time != null) {
            this.REQUEST_MAP.remove(id);
            return System.currentTimeMillis() - time;
        }
        throw new Exception("ID [" + id + "] was not found int the map.");
    }
}

