/*
 * Decompiled with CFR 0.152.
 */
package cloud.cirrusup;

import cloud.cirrusup.RandomGenerator;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.handlers.RequestHandler2;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsLatencyRequestLogHandler
extends RequestHandler2 {
    private static final String LOG_NAME = "aws-latency-log";
    private static final String REQUEST_ID = "requestId";
    private static final Logger LOG = LoggerFactory.getLogger((String)"aws-latency-log");
    private final ConcurrentHashMap<String, Long> REQUEST_MAP = new ConcurrentHashMap();

    public void beforeRequest(Request<?> request) {
        String id = RandomGenerator.getUUIDRandomString();
        LOG.info("ID [{}] - Request done to the service [{}] with the method [{}]", new Object[]{id, request.getServiceName(), request.getHttpMethod()});
        request.getHeaders().put(REQUEST_ID, id);
        this.REQUEST_MAP.put(id, System.currentTimeMillis());
    }

    public void afterResponse(Request<?> request, Response<?> response) {
        String id = (String)request.getHeaders().get(REQUEST_ID);
        try {
            LOG.info("Request ID [{}] took [{}] milliseconds and returned the RESPONSE_CODE [{}]", new Object[]{id, this.getTime(id), this.getStatusCode(response, null)});
        }
        catch (Exception ex) {
            LOG.error("ID [{}] for the request to [{}] was not found.", (Object)id, (Object)request.getServiceName());
        }
    }

    public void afterError(Request<?> request, Response<?> response, Exception e) {
        String id = (String)request.getHeaders().get(REQUEST_ID);
        try {
            LOG.error("Request ID [{}] took [{}] milliseconds and returned the RESPONSE_CODE [{}] and ERROR_MESSAGE [{}]", new Object[]{id, this.getTime(id), this.getStatusCode(response, e), e.getMessage()});
        }
        catch (Exception ex) {
            LOG.error("ID [{}] for the request to [{}] was not found.", (Object)id, (Object)request.getServiceName());
        }
    }

    private int getStatusCode(Response<?> response, Exception e) {
        if (response != null && response.getHttpResponse() != null) {
            return response.getHttpResponse().getStatusCode();
        }
        if (e != null && e instanceof AmazonServiceException) {
            return ((AmazonServiceException)e).getStatusCode();
        }
        return -1;
    }

    private long getTime(String id) throws Exception {
        Long time = this.REQUEST_MAP.get(id);
        if (time != null) {
            this.REQUEST_MAP.remove(id);
            return System.currentTimeMillis() - time;
        }
        throw new Exception("ID [" + id + "] was not found int the map.");
    }
}

