/*
 * Decompiled with CFR 0.152.
 */
package cloud.atlassian.provisioning;

import cloud.atlassian.provisioning.TenantedEventManager;
import cloud.atlassian.provisioning.TenantedPlatformInitialisedEvent;
import cloud.atlassian.provisioning.TenantedPlatformListener;
import cloud.atlassian.provisioning.TenantedProductEvent;
import cloud.atlassian.provisioning.TenantedProductListener;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;

public class DefaultTenantedEventManager
implements TenantedEventManager {
    private final Queue<WeightedPlatformListener> platformListeners = new PriorityBlockingQueue<WeightedPlatformListener>(10, (item1, item2) -> ((WeightedPlatformListener)item1).weight - ((WeightedPlatformListener)item2).weight);
    private final Queue<WeightedProductListener> productActivationListeners = new PriorityBlockingQueue<WeightedProductListener>(10, (item1, item2) -> ((WeightedProductListener)item1).weight - ((WeightedProductListener)item2).weight);
    private final Queue<WeightedProductListener> productDeactivationListeners = new PriorityBlockingQueue<WeightedProductListener>(10, (item1, item2) -> ((WeightedProductListener)item1).weight - ((WeightedProductListener)item2).weight);

    @Override
    public void registerPlatformInitialisedListener(TenantedPlatformListener listener, int weight) {
        this.platformListeners.add(new WeightedPlatformListener(listener, weight));
    }

    @Override
    public void registerProductActivationListener(TenantedProductListener listener, int weight) {
        this.productActivationListeners.add(new WeightedProductListener(listener, weight));
    }

    @Override
    public void registerProductDeactivationListener(TenantedProductListener listener, int weight) {
        this.productDeactivationListeners.add(new WeightedProductListener(listener, weight));
    }

    @Override
    public void firePlatformInitialisedEvent() {
        TenantedPlatformInitialisedEvent event = new TenantedPlatformInitialisedEvent();
        this.platformListeners.forEach(element -> ((WeightedPlatformListener)element).listener.platformInitialised(event));
    }

    @Override
    public void fireProductActivatedEvent(String product) {
        TenantedProductEvent event = new TenantedProductEvent(product, true);
        this.productActivationListeners.forEach(element -> ((WeightedProductListener)element).listener.productActivated(event));
    }

    @Override
    public void fireProductDeactivatedEvent(String product) {
        TenantedProductEvent event = new TenantedProductEvent(product, false);
        this.productDeactivationListeners.forEach(element -> ((WeightedProductListener)element).listener.productDeactivated(event));
    }

    protected static class WeightedProductListener {
        private final TenantedProductListener listener;
        private final int weight;

        WeightedProductListener(TenantedProductListener listener, int weight) {
            this.listener = listener;
            this.weight = weight;
        }
    }

    protected static class WeightedPlatformListener {
        private final TenantedPlatformListener listener;
        private final int weight;

        WeightedPlatformListener(TenantedPlatformListener listener, int weight) {
            this.listener = listener;
            this.weight = weight;
        }
    }
}

