/*
 * Decompiled with CFR 0.152.
 */
package it.com.atlassian.gadgets.pages;

import com.atlassian.pageobjects.Page;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.google.common.collect.ImmutableList;
import it.com.atlassian.gadgets.pages.AddGadgetDialog;
import it.com.atlassian.gadgets.pages.ConfigurableGadget;
import it.com.atlassian.gadgets.pages.DashboardToolsMenu;
import it.com.atlassian.gadgets.pages.EditLayoutDialog;
import it.com.atlassian.gadgets.pages.Gadget;
import it.com.atlassian.gadgets.pages.util.DashboardGadgets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class GadgetsDashboardPage
implements Page {
    private final int dashboardId;
    private final Locale locale;
    private final int tokenRefreshRate;
    @Inject
    protected AtlassianWebDriver atlassianWebDriver;
    @Inject
    protected PageBinder pageBinder;
    @FindBy(id="dashboard")
    private WebElement dashboardWebElement;
    @ElementBy(id="dashboard")
    protected PageElement dashboardPageElement;
    @FindBy(id="add-gadget")
    private WebElement addDialogLink;
    @FindBy(id="layout-changer")
    private WebElement editLayoutLink;
    @Inject
    protected PageElementFinder finder;

    public GadgetsDashboardPage(Integer dashboardId, Locale locale, Integer tokenRefreshRate) {
        this.dashboardId = dashboardId;
        this.locale = locale;
        this.tokenRefreshRate = tokenRefreshRate;
    }

    public GadgetsDashboardPage(Integer dashboardId) {
        this(dashboardId, Locale.getDefault(), 50000);
    }

    public WebElement getColumn(int column) {
        String selector = ".column";
        if (column == 0) {
            selector = selector + ".first";
        } else if (column == 1) {
            selector = selector + ".second";
        } else if (column == 2) {
            selector = selector + ".third";
        }
        return this.dashboardWebElement.findElement(By.cssSelector((String)selector));
    }

    public GadgetsDashboardPage refresh() {
        this.atlassianWebDriver.navigate().refresh();
        return (GadgetsDashboardPage)this.pageBinder.bind(this.getClass(), new Object[]{this.getId()});
    }

    public List<Gadget> getGadgetsForColumn(int column) {
        ArrayList<Gadget> gadgets = new ArrayList<Gadget>();
        List $gadgets = this.getColumn(column).findElements(By.className((String)"gadget"));
        for (WebElement $gadget : $gadgets) {
            Gadget gadget = this.getGadget($gadget.getAttribute("id").replace("-renderbox", ""));
            gadgets.add(gadget);
        }
        return gadgets;
    }

    public String getUrl() {
        return "/plugins/servlet/dashboards/" + this.dashboardId + "?locale.lang=" + this.locale.getLanguage() + "&locale.country=" + this.locale.getCountry() + "&locale.variant=" + this.locale.getVariant() + "&__st_refresh=" + this.tokenRefreshRate;
    }

    public int getId() {
        return this.dashboardId;
    }

    public DashboardToolsMenu openToolsMenu() {
        return ((DashboardToolsMenu)this.pageBinder.bind(DashboardToolsMenu.class, new Object[0])).open();
    }

    @WaitUntil
    public void waitUntilDashboardRendered() {
        this.atlassianWebDriver.waitUntilElementIsNotLocatedAt(By.className((String)"initializing"), (SearchContext)this.dashboardWebElement);
    }

    public AddGadgetDialog openAddGadgetDialog() {
        this.addDialogLink.click();
        return (AddGadgetDialog)this.pageBinder.bind(AddGadgetDialog.class, new Object[]{this.dashboardId});
    }

    public EditLayoutDialog openEditLayoutDialog() {
        this.editLayoutLink.click();
        return (EditLayoutDialog)this.pageBinder.bind(EditLayoutDialog.class, new Object[0]);
    }

    public Gadget getGadgetWithTitle(String title) {
        return this.getGadget(this.getGadgetIdTitled(title));
    }

    public String getLayout() {
        return this.dashboardWebElement.findElement(By.className((String)"layout")).getAttribute("className").replace("layout layout-", "");
    }

    public <T extends Gadget> T getGadgetWithTitle(String title, Class<T> gadget) {
        return (T)((Gadget)this.pageBinder.bind(gadget, new Object[]{this.getGadgetIdTitled(title)}));
    }

    public Boolean canAddGadget() {
        return this.atlassianWebDriver.elementExists(By.id((String)"add-gadget"));
    }

    public Boolean canEditLayout() {
        return this.atlassianWebDriver.elementExists(By.id((String)"layout-changer"));
    }

    public Gadget getGadget(String gadgetId) {
        if (gadgetId == null) {
            return null;
        }
        if (this.atlassianWebDriver.elementExists(By.cssSelector((String)("#" + gadgetId + "-renderbox .aui-dropdown .edit")))) {
            return (Gadget)this.pageBinder.bind(ConfigurableGadget.class, new Object[]{gadgetId});
        }
        return (Gadget)this.pageBinder.bind(Gadget.class, new Object[]{gadgetId});
    }

    public boolean gadgetExists(String gadgetId) {
        return this.finder.find(By.cssSelector((String)("#" + gadgetId))).isPresent();
    }

    public boolean containsGadgetWithTitle(String gadgetTitle) {
        return DashboardGadgets.findGadgetIdByTitleOrNull(this.dashboardPageElement, gadgetTitle) != null;
    }

    public Gadget addItem(String itemName) {
        return this.openAddGadgetDialog().addGadget(itemName).close().getGadgetWithTitle(itemName);
    }

    private String getGadgetIdTitled(String gadgetTitle) {
        return DashboardGadgets.findGadgetIdByTitleOrNull(this.dashboardPageElement, gadgetTitle);
    }

    public boolean hasTabsContainer() {
        return this.dashboardPageElement.find(By.cssSelector((String)".dashboard-tabs.vertical")).isPresent();
    }

    public List<String> getTabsNames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (PageElement link : this.dashboardPageElement.findAll(By.cssSelector((String)".dashboard-tabs.vertical li"))) {
            builder.add((Object)link.getText());
        }
        return builder.build();
    }

    public List<String> getCurrentTabsNames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (PageElement link : this.dashboardPageElement.findAll(By.cssSelector((String)".dashboard-tabs.vertical li.active"))) {
            builder.add((Object)link.getText());
        }
        return builder.build();
    }

    public String getHeader() {
        return this.dashboardPageElement.find(By.cssSelector((String)".aui-page-header h1")).getText();
    }

    public GadgetsDashboardPage switchDashboard(String dashboardName, int dashboardId) {
        this.dashboardPageElement.find(By.linkText((String)dashboardName)).click();
        this.atlassianWebDriver.waitUntil(webDriver -> dashboardName.equals(this.atlassianWebDriver.findElement(By.cssSelector((String)".aui-page-header h1")).getText()));
        return (GadgetsDashboardPage)this.pageBinder.bind(GadgetsDashboardPage.class, new Object[]{dashboardId, this.locale, this.tokenRefreshRate});
    }
}

