/*
 * Decompiled with CFR 0.152.
 */
package it.com.atlassian.gadgets.pages;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementActions;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.AtlassianWebDriver;
import it.com.atlassian.gadgets.pages.GadgetMenu;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class Gadget
implements PageElementFinder {
    @Inject
    protected AtlassianWebDriver driver;
    @Inject
    protected PageBinder pageBinder;
    @Inject
    protected PageElementFinder finder;
    @Inject
    protected PageElementActions actions;
    private final String id;

    public Gadget(String id) {
        this.id = id;
    }

    public PageElement getChrome() {
        this.switchBack();
        return this.finder.find(By.id((String)(this.id + "-renderbox")));
    }

    protected WebElement getChromeWebElement() {
        this.switchBack();
        return this.driver.findElement(By.id((String)(this.id + "-renderbox")));
    }

    protected PageElement getMain() {
        this.switchToIframe();
        return this.finder.find(By.id((String)"main"));
    }

    protected WebElement getMainWebElement() {
        this.switchToIframe();
        return this.driver.findElement(By.id((String)"main"));
    }

    public String getId() {
        return this.id;
    }

    public PageElement getTitleBar() {
        return this.getChrome().find(By.className((String)"dashboard-item-title"));
    }

    protected WebElement getTitleBarWebElement() {
        return this.getChromeWebElement().findElement(By.className((String)"dashboard-item-title"));
    }

    public Gadget minimize() {
        this.openMenu().selectByClassName("minimization");
        return this;
    }

    public GadgetMenu openMenu() {
        this.driver.switchTo().defaultContent();
        return ((GadgetMenu)this.pageBinder.bind(GadgetMenu.class, new Object[]{this.id})).open();
    }

    public String getHtml() {
        this.switchToIframe();
        return this.driver.getPageSource();
    }

    public String getText() {
        this.switchToIframe();
        return this.driver.findElement(By.tagName((String)"body")).getText();
    }

    public Gadget maximize() {
        this.openMenu().selectByClassName("maximization");
        return this;
    }

    public Gadget dragTo(WebElement column) throws Exception {
        return this.dragTo(column.getLocation());
    }

    public Gadget dragTo(PageElement column) throws Exception {
        return this.dragTo(column.getLocation());
    }

    public Gadget dragTo(Point newPosition) throws Exception {
        PageElement titleBar = this.getTitleBar();
        Point titlePosition = titleBar.getLocation();
        this.actions.dragAndDropBy(titleBar, newPosition.x - titlePosition.x + 100, newPosition.y - titlePosition.y + 100).perform();
        Poller.waitUntilFalse((TimedQuery)this.getChrome().timed().hasClass("dragging"));
        return this;
    }

    public Boolean isMinimized() {
        return this.getChrome().find(By.className((String)"dashboard-item-content")).hasClass("minimization");
    }

    public String getMainText() {
        return this.getMain().getText();
    }

    public boolean isDashboardItem() {
        return this.getChrome().find(By.className((String)"gadget-inline")).isPresent();
    }

    public String getDashboardItemText() {
        return this.getChrome().find(By.className((String)"main")).getText();
    }

    public Gadget changeColor(String colorClass) {
        this.openMenu().selectByCSSSelector("." + colorClass + " a");
        return this;
    }

    public String getErrorMsgText() {
        this.switchToIframe();
        return this.driver.findElement(By.cssSelector((String)".aui-message.error")).getText();
    }

    public String getColor() {
        return this.getChrome().getAttribute("className").replaceAll(".*(color\\d).*", "$1");
    }

    public Gadget switchToIframe() {
        try {
            this.driver.switchTo().defaultContent();
            this.driver.switchTo().frame(this.id);
        }
        catch (NoSuchFrameException noSuchFrameException) {
            // empty catch block
        }
        return this;
    }

    public Gadget switchTo() {
        return this.switchToIframe();
    }

    public <T> T switchTo(Class<T> cls) {
        this.driver.switchTo().frame(this.id);
        return (T)this.pageBinder.bind(cls, new Object[0]);
    }

    public void switchBack() {
        this.driver.switchTo().defaultContent();
    }

    public Gadget delete() {
        this.openMenu().selectByClassName("delete");
        this.driver.switchTo().alert().accept();
        Poller.waitUntilFalse((TimedQuery)this.getChrome().timed().isPresent());
        return this;
    }

    public PageElement find(By by) {
        this.switchTo();
        return this.finder.find(by);
    }

    public PageElement find(By by, TimeoutType timeoutType) {
        this.switchTo();
        return this.finder.find(by, timeoutType);
    }

    public List<PageElement> findAll(By by) {
        this.switchTo();
        return this.finder.findAll(by);
    }

    public List<PageElement> findAll(By by, TimeoutType timeoutType) {
        this.switchTo();
        return this.finder.findAll(by, timeoutType);
    }

    public <T extends PageElement> T find(By by, Class<T> elementClass) {
        this.switchTo();
        return (T)this.finder.find(by, elementClass);
    }

    public <T extends PageElement> T find(By by, Class<T> elementClass, TimeoutType timeoutType) {
        this.switchTo();
        return (T)this.finder.find(by, elementClass, timeoutType);
    }

    public <T extends PageElement> List<T> findAll(By by, Class<T> elementClass) {
        this.switchTo();
        return this.finder.findAll(by, elementClass);
    }

    public <T extends PageElement> List<T> findAll(By by, Class<T> elementClass, TimeoutType timeoutType) {
        this.switchTo();
        return this.finder.findAll(by, elementClass, timeoutType);
    }
}

