/*
 * Decompiled with CFR 0.152.
 */
package it.com.atlassian.gadgets.pages;

import it.com.atlassian.gadgets.pages.Gadget;
import it.com.atlassian.gadgets.pages.GadgetMenu;
import it.com.atlassian.gadgets.pages.fields.BoolPref;
import it.com.atlassian.gadgets.pages.fields.EnumPref;
import it.com.atlassian.gadgets.pages.fields.ListPref;
import it.com.atlassian.gadgets.pages.fields.StringPref;
import it.com.atlassian.gadgets.pages.fields.UserPrefField;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class ConfigurableGadget
extends Gadget {
    public ConfigurableGadget(String id) {
        super(id);
    }

    public ConfigurableGadget configure() {
        GadgetMenu menu = this.openMenu();
        menu.selectByCSSSelector(this.getConfigTriggerCss());
        return this;
    }

    public ConfigurableGadget submit() {
        this.getConfig().submit();
        this.switchToIframe();
        return this;
    }

    public String getConfigTriggerCss() {
        return ".item-link.edit";
    }

    public WebElement getConfig() {
        return this.getChromeWebElement().findElement(By.id((String)(this.getId() + "-edit")));
    }

    protected List<WebElement> getFields(String name) {
        List $inputs = this.getConfig().findElements(By.cssSelector((String)"input"));
        $inputs.addAll(this.getConfig().findElements(By.cssSelector((String)"select")));
        $inputs.addAll(this.getConfig().findElements(By.cssSelector((String)"textarea")));
        ArrayList<WebElement> $fields = new ArrayList<WebElement>();
        for (WebElement $input : $inputs) {
            if (!$input.getAttribute("name").equals(name)) continue;
            $fields.add($input);
        }
        return $fields;
    }

    public UserPrefField getFieldWithName(String name) {
        List<WebElement> $fields = this.getFields(name);
        WebElement $field = $fields.get(0);
        String className = $field.getAttribute("className");
        if (className.contains("string")) {
            return new StringPref($field);
        }
        if (className.contains("bool")) {
            return new BoolPref($field);
        }
        if (className.contains("enum")) {
            return new EnumPref($field);
        }
        if (className.contains("list")) {
            WebElement $container = this.getConfig().findElement(By.id((String)(name + "-container")));
            return new ListPref($container);
        }
        return null;
    }
}

