/*
 * Decompiled with CFR 0.152.
 */
package it.com.atlassian.gadgets.pages;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.atlassian.webdriver.utils.Search;
import it.com.atlassian.gadgets.pages.GadgetsDashboardPage;
import it.com.atlassian.gadgets.pages.util.DashboardGadgets;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AddGadgetDialog {
    @Inject
    private AtlassianWebDriver driver;
    @Inject
    private PageBinder pageBinder;
    @FindBy(id="gadget-dialog")
    private WebElement dialog;
    @FindBy(id="search")
    private WebElement search;
    @FindBy(className="dialog-page-menu")
    private WebElement categories;
    @FindBy(id="list-panel")
    private WebElement gadgetsList;
    @FindBy(className="aui-iconfont-close-dialog")
    private WebElement closeDialogLink;
    @ElementBy(id="dashboard")
    protected PageElement dashboardPageElement;
    @Inject
    protected PageElementFinder finder;
    private final Integer dashboardId;

    public AddGadgetDialog() {
        this.dashboardId = null;
    }

    public AddGadgetDialog(Integer dashboardId) {
        this.dashboardId = dashboardId;
    }

    @WaitUntil
    public void waitForVisible() {
        this.driver.waitUntilElementIsVisibleAt(By.id((String)"directory-page"), (SearchContext)this.dialog);
    }

    public AddGadgetDialog searchFor(String value) {
        this.search.sendKeys(new CharSequence[]{value});
        return this;
    }

    public AddGadgetDialog waitFor(String gadgetTitle) {
        this.driver.waitUntilElementIsVisibleAt(this.gadgetSelector(gadgetTitle), (SearchContext)this.dialog);
        return this;
    }

    public boolean isGadgetVisible(String gadgetTitle) {
        return this.driver.elementIsVisibleAt(this.gadgetSelector(gadgetTitle), (SearchContext)this.dialog);
    }

    public String getGadgetAuthor(String gadgetTitle) {
        return this.dialog.findElement(this.gadgetSelector(gadgetTitle)).findElement(By.className((String)"item-author")).getText().replaceAll("By (.+).\\s\\w+$", "$1").trim();
    }

    public String getGadgetDescription(String gadgetTitle) {
        return this.dialog.findElement(this.gadgetSelector(gadgetTitle)).findElement(By.xpath((String)"div[@class='aui-item item-description']/p[2]")).getText();
    }

    public String getGadgetThumbnailSrc(String gadgetTitle) {
        return this.dialog.findElement(this.gadgetSelector(gadgetTitle)).findElement(By.xpath((String)"div[@class='aui-item item-thumbnail']/img")).getAttribute("src");
    }

    public List<String> getVisibleGadgets() {
        this.loadAllVisibleGadgets();
        ArrayList<String> titles = new ArrayList<String>();
        for (WebElement gadget : Search.findVisibleElements((By)By.cssSelector((String)"div.aui-group[data-item-title]"), (SearchContext)this.gadgetsList)) {
            titles.add(gadget.getAttribute("data-item-title"));
        }
        return titles;
    }

    public AddGadgetDialog setCategory(String categoryName) {
        WebElement cat = this.dialog.findElement(By.cssSelector((String)String.format("a[data-category-label='%s']", categoryName)));
        cat.click();
        return this;
    }

    public AddGadgetDialog addGadget(String gadgetTitle) {
        this.loadAllVisibleGadgets();
        WebElement addButton = this.dialog.findElement(this.gadgetSelector(gadgetTitle)).findElement(By.className((String)"add-dashboard-item-selector"));
        addButton.click();
        this.driver.waitUntil(input -> DashboardGadgets.findGadgetIdByTitleOrNull(this.dashboardPageElement, gadgetTitle) != null);
        return this;
    }

    public GadgetsDashboardPage close() {
        if (this.dashboardId == null) {
            throw new IllegalStateException("You cannot use close when you have undefined dashboardId. You have to either set dashboardId during construction or use simple close.");
        }
        this.simpleClose();
        return (GadgetsDashboardPage)this.pageBinder.bind(GadgetsDashboardPage.class, new Object[]{this.dashboardId});
    }

    public void simpleClose() {
        this.closeDialogLink.click();
        this.driver.waitUntilElementIsNotVisibleAt(By.className((String)"dialog-title"), (SearchContext)this.dialog);
    }

    public AddGadgetDialog loadAllVisibleGadgets() {
        PageElement loadMoreDirectoryItems;
        if (this.driver.elementExistsAt(By.id((String)"in-progress-message"), (SearchContext)this.dialog)) {
            this.driver.waitUntilElementIsVisibleAt(By.id((String)"load-more-directory-items"), (SearchContext)this.dialog);
        }
        if ((loadMoreDirectoryItems = this.finder.find(By.id((String)"load-more-directory-items"))).isPresent() && loadMoreDirectoryItems.isVisible()) {
            loadMoreDirectoryItems.click();
        }
        this.driver.waitUntilElementIsNotVisible(By.id((String)"more-data-message"));
        return this;
    }

    private By gadgetSelector(String gadgetTitle) {
        return By.cssSelector((String)String.format("div[data-item-title='%s']", gadgetTitle));
    }
}

