/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.websocket;

import cloud.artik.api.ArtikCloudApiTest;
import cloud.artik.model.Acknowledgement;
import cloud.artik.model.ActionOut;
import cloud.artik.model.MessageIn;
import cloud.artik.model.MessageOut;
import cloud.artik.model.RegisterMessage;
import cloud.artik.model.WebSocketError;
import cloud.artik.websocket.ArtikCloudWebSocketCallback;
import cloud.artik.websocket.DeviceChannelWebSocket;
import cloud.artik.websocket.FirehoseWebSocket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FirehoseWebSocketTest
extends ArtikCloudApiTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testFirehose1() throws Exception {
        String deviceId = this.getProperty("device3.id");
        String userId = this.getProperty("user1.id");
        String accessToken = this.getProperty("device3.token");
        CountDownLatch messageLatch = new CountDownLatch(1000);
        FirehoseWebSocket firehoseWS = new FirehoseWebSocket(accessToken, deviceId, null, null, userId, new ArtikCloudWebSocketCallback(){

            public void onAck(Acknowledgement ack) {
                System.out.println("onAck: " + ack);
            }

            public void onAction(ActionOut action) {
                System.out.println("onAction: " + action);
            }

            public void onClose(int code, String reason, boolean remote) {
                System.out.printf("onClose: %d %s %s\n", code, reason, remote);
            }

            public void onError(WebSocketError error) {
                System.err.println("onError: " + error);
            }

            public void onMessage(MessageOut message) {
            }

            public void onOpen(int httpStatus, String httpStatusMessage) {
                System.out.printf("onOpen: %d %s\n", httpStatus, httpStatusMessage);
            }

            public void onPing(long timestamp) {
                System.err.println("onPing: " + timestamp);
            }
        });
        firehoseWS.connect();
        messageLatch.await(100L, TimeUnit.SECONDS);
        firehoseWS.closeBlocking();
    }

    @Test
    public void testFirehose2() throws Exception {
        String deviceId = this.getProperty("device2.id");
        String userId = this.getProperty("user1.id");
        String accessToken = this.getProperty("device2.token");
        final CountDownLatch registerLatch = new CountDownLatch(1);
        final CountDownLatch messageLatch = new CountDownLatch(1000);
        DeviceChannelWebSocket ws = new DeviceChannelWebSocket(true, new ArtikCloudWebSocketCallback(){

            public void onAck(Acknowledgement ack) {
                System.out.println("onAck: " + ack);
                if (ack.getCid().equalsIgnoreCase("first")) {
                    registerLatch.countDown();
                }
            }

            public void onAction(ActionOut action) {
                System.out.println("onAction: " + action);
            }

            public void onClose(int code, String reason, boolean remote) {
                System.out.printf("onClose: %d %s %s\n", code, reason, remote);
            }

            public void onError(WebSocketError error) {
                System.err.println("onError: " + error);
            }

            public void onMessage(MessageOut message) {
                System.out.println("onMessage: " + message);
            }

            public void onOpen(int httpStatus, String httpStatusMessage) {
                System.out.printf("onOpen: %d %s\n", httpStatus, httpStatusMessage);
            }

            public void onPing(long timestamp) {
                System.out.println("onPing: " + timestamp);
            }
        });
        ws.connectBlocking();
        RegisterMessage msg = new RegisterMessage();
        msg.setAuthorization("bearer " + accessToken);
        msg.setSdid(deviceId);
        msg.setCid("first");
        ws.registerChannel(msg);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)new Boolean(registerLatch.await(10L, TimeUnit.SECONDS)));
        FirehoseWebSocket firehoseWS = new FirehoseWebSocket(accessToken, deviceId, null, null, userId, new ArtikCloudWebSocketCallback(){

            public void onAck(Acknowledgement ack) {
                System.out.println("onAck: " + ack);
            }

            public void onAction(ActionOut action) {
                System.out.println("onAction: " + action);
            }

            public void onClose(int code, String reason, boolean remote) {
                System.out.printf("onClose: %d %s %s\n", code, reason, remote);
            }

            public void onError(WebSocketError error) {
                System.err.println("onError: " + error);
            }

            public void onMessage(MessageOut message) {
                System.out.println("Firehose: onMessage: " + message);
                messageLatch.countDown();
            }

            public void onOpen(int httpStatus, String httpStatusMessage) {
                System.out.printf("onOpen: %d %s\n", httpStatus, httpStatusMessage);
            }

            public void onPing(long timestamp) {
                System.err.println("onPing: " + timestamp);
            }
        });
        firehoseWS.connect();
        for (int i = 0; i < 1000; ++i) {
            MessageIn message = new MessageIn();
            message.setSdid(deviceId);
            message.setTs(new Long(System.currentTimeMillis()));
            message.getData().put("steps", new Integer(500));
            message.setCid("second");
            ws.sendMessage(message);
        }
        messageLatch.await(100L, TimeUnit.SECONDS);
        firehoseWS.closeBlocking();
        ws.closeBlocking();
    }
}

