/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.websocket;

import cloud.artik.api.ArtikCloudApiTest;
import cloud.artik.model.Acknowledgement;
import cloud.artik.model.ActionOut;
import cloud.artik.model.EventFeedData;
import cloud.artik.model.MessageOut;
import cloud.artik.model.WebSocketError;
import cloud.artik.websocket.ArtikCloudWebSocketCallback;
import cloud.artik.websocket.EventFeedWebSocket;
import cloud.artik.websocket.EventFeedWebSocketCallback;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class EventFeedWebSocketTest
extends ArtikCloudApiTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testSendEvent() throws Exception {
        String accessToken = this.getProperty("user1.token");
        CountDownLatch registerLatch = new CountDownLatch(1);
        CountDownLatch eventLatch = new CountDownLatch(1);
        EventFeedCallback callback = new EventFeedCallback(registerLatch, eventLatch);
        EventFeedWebSocket eventWS = new EventFeedWebSocket(accessToken, null, null, null, null, (ArtikCloudWebSocketCallback)callback, (EventFeedWebSocketCallback)callback);
        eventWS.connectBlocking();
        eventLatch.await(100L, TimeUnit.SECONDS);
        eventWS.closeBlocking();
    }

    public class EventFeedCallback
    implements EventFeedWebSocketCallback,
    ArtikCloudWebSocketCallback {
        private CountDownLatch registerLatch;
        private CountDownLatch eventLatch;

        public EventFeedCallback(CountDownLatch registerLatch, CountDownLatch eventLatch) {
            this.registerLatch = registerLatch;
            this.eventLatch = eventLatch;
        }

        public void onAck(Acknowledgement ack) {
            System.out.println("onAck: " + ack);
            if (ack.getCid().equalsIgnoreCase("first")) {
                this.registerLatch.countDown();
            }
        }

        public void onAction(ActionOut action) {
            System.out.println("onAction: " + action);
        }

        public void onClose(int code, String reason, boolean remote) {
            System.out.printf("onClose: %d %s %s\n", code, reason, remote);
        }

        public void onError(WebSocketError error) {
            System.err.println("onError: " + error);
        }

        public void onMessage(MessageOut message) {
            System.out.println("onMessage: " + message);
        }

        public void onOpen(int httpStatus, String httpStatusMessage) {
            System.out.printf("onOpen: %d %s\n", httpStatus, httpStatusMessage);
        }

        public void onPing(long timestamp) {
            System.out.println("onPing: " + timestamp);
        }

        public void onEvent(EventFeedData eventFeedData) {
            System.out.println("onEvent: " + eventFeedData);
            this.eventLatch.countDown();
        }
    }
}

