/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.api;

import cloud.artik.api.ArtikCloudApiTest;
import cloud.artik.api.UsersApi;
import cloud.artik.client.ApiException;
import cloud.artik.model.AppProperties;
import cloud.artik.model.DeviceTypesEnvelope;
import cloud.artik.model.DevicesEnvelope;
import cloud.artik.model.PropertiesEnvelope;
import cloud.artik.model.RulesEnvelope;
import cloud.artik.model.User;
import cloud.artik.model.UserEnvelope;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UsersApiTest
extends ArtikCloudApiTest {
    protected UsersApi apiClient = null;
    protected String userId = null;

    @Before
    public void setUp() throws Exception {
        this.apiClient = (UsersApi)super.api(UsersApi.class, "user1.token");
        this.userId = this.apiClient.getSelf().getData().getId();
    }

    @After
    public void tearDown() throws Exception {
        this.apiClient = null;
    }

    @Test
    public void testGetSelf() throws Exception {
        UserEnvelope userEnvelope = this.apiClient.getSelf();
        Assert.assertNotNull((Object)userEnvelope);
        User user = userEnvelope.getData();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)this.getProperty("user1.email"), (Object)user.getEmail());
        Assert.assertEquals((Object)this.getProperty("user1.id"), (Object)user.getId());
        Assert.assertEquals((Object)this.getProperty("user1.name"), (Object)user.getName());
        Assert.assertEquals((Object)this.getProperty("user1.fullname"), (Object)user.getFullName());
        Assert.assertEquals((Object)this.getProperty("user1.createdon"), (Object)user.getCreatedOn().toString());
        Assert.assertNotNull((Object)user.getModifiedOn());
    }

    @Test
    public void testGetUserDevices() throws Exception {
        DevicesEnvelope userDevicesEnvelope = this.apiClient.getUserDevices(this.userId, null, null, null);
        Assert.assertNotNull((Object)userDevicesEnvelope);
        Assert.assertNotNull((Object)userDevicesEnvelope.getData().getDevices());
    }

    @Test
    public void testGetUserDeviceTypes() throws Exception {
        DeviceTypesEnvelope deviceTypesEnvelope = this.apiClient.getUserDeviceTypes(this.userId, null, null, null);
        Assert.assertNotNull((Object)deviceTypesEnvelope);
        Assert.assertNotNull((Object)deviceTypesEnvelope.getData().getDeviceTypes());
    }

    @Test
    public void testUserProperties() throws Exception {
        String aid = this.getProperty("user1.aid");
        PropertiesEnvelope userProperties = null;
        try {
            userProperties = this.apiClient.getUserProperties(this.userId, aid);
        }
        catch (ApiException apiException) {
            if (apiException.getCode() == 404) {
                AppProperties appProperties = new AppProperties();
                appProperties.setProperties("abc=def");
                userProperties = this.apiClient.createUserProperties(this.userId, appProperties, aid);
            }
            Assert.fail((String)"Non-404 Error returned by API");
        }
        Assert.assertNotNull((Object)userProperties);
        AppProperties appProperties2 = new AppProperties();
        appProperties2.setProperties("mno=pqr");
        PropertiesEnvelope userProperties2 = this.apiClient.updateUserProperties(this.userId, appProperties2, aid);
        Assert.assertNotNull((Object)userProperties2);
        Assert.assertEquals((String)"Properties must be the same", (Object)"mno=pqr", (Object)userProperties2.getData().getProperties());
        PropertiesEnvelope userProperties3 = this.apiClient.deleteUserProperties(this.userId, aid);
        Assert.assertNotNull((Object)userProperties3);
        Assert.assertEquals((Object)userProperties2, (Object)userProperties3);
    }

    @Test
    public void testGetUserRules() throws Exception {
        RulesEnvelope rulesEnvelope = this.apiClient.getUserRules(this.userId, Boolean.valueOf(false), null, null);
        Assert.assertNotNull((Object)rulesEnvelope);
    }
}

