/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.api;

import cloud.artik.api.ArtikCloudApiTest;
import cloud.artik.api.MessagesApi;
import cloud.artik.client.ApiCallback;
import cloud.artik.client.ApiException;
import cloud.artik.model.Action;
import cloud.artik.model.ActionArray;
import cloud.artik.model.Actions;
import cloud.artik.model.Message;
import cloud.artik.model.MessageAction;
import cloud.artik.model.MessageIDEnvelope;
import cloud.artik.model.NormalizedAction;
import cloud.artik.model.NormalizedActionsEnvelope;
import cloud.artik.model.NormalizedMessage;
import cloud.artik.model.NormalizedMessagesEnvelope;
import cloud.artik.model.SnapshotResponse;
import cloud.artik.model.SnapshotResponses;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessagesApiTest
extends ArtikCloudApiTest {
    protected MessagesApi apiClient = null;

    @Before
    public void setUp() throws Exception {
        this.apiClient = (MessagesApi)super.api(MessagesApi.class, "device1.token");
    }

    @After
    public void tearDown() throws Exception {
        this.apiClient = null;
    }

    @Test
    public void testSendMessage() throws Exception {
        Message message = new Message();
        message.setSdid(this.getProperty("device1.id"));
        message.setTs(new Long(System.currentTimeMillis()));
        message.getData().put("steps", new Integer(500));
        String messageId = this.apiClient.sendMessage(message).getData().getMid();
        Assert.assertNotNull((String)"Message ID should not be null", (Object)messageId);
        Thread.sleep(2000L);
        NormalizedMessagesEnvelope envelope = this.apiClient.getNormalizedMessages(null, null, messageId, null, null, null, null, null, null, null);
        Assert.assertEquals((Object)new Long(1L), (Object)envelope.getSize());
        NormalizedMessage normalized = (NormalizedMessage)envelope.getData().get(0);
        Assert.assertEquals((Object)messageId, (Object)normalized.getMid());
        Object steps = normalized.getData().get("steps");
        Assert.assertNotNull((String)"Volume should not be null", steps);
        Assert.assertEquals((Object)new Double(500.0), steps);
    }

    @Test
    public void testGetMessageSnapshots() throws Exception {
        String sdids = this.getProperty("device1.id");
        SnapshotResponses env = this.apiClient.getMessageSnapshots(sdids, Boolean.valueOf(false));
        Assert.assertEquals((String)"SDIDs must match", (Object)sdids, (Object)env.getSdids());
        Assert.assertEquals((String)"SDID must match", (Object)sdids, (Object)((SnapshotResponse)env.getData().get(0)).getSdid());
        Map stepsInfo = (Map)((SnapshotResponse)env.getData().get(0)).getData().get("steps");
        Assert.assertEquals((String)"Steps must be 500", (Object)500.0, stepsInfo.get("value"));
    }

    @Test
    public void testSendActions() throws Exception {
        String ddid = this.getProperty("device4.id");
        MessagesApi newApi = (MessagesApi)super.api(MessagesApi.class, "user1.token");
        Action action = new Action();
        action.setName("setVolume");
        action.getParameters().put("volume", 5);
        ActionArray actionArray = new ActionArray();
        actionArray.getActions().add(action);
        Actions actions = new Actions();
        actions.setDdid(ddid);
        actions.setTs(new Long(System.currentTimeMillis()));
        actions.setData(actionArray);
        String mid = newApi.sendActions(actions).getData().getMid();
        Thread.sleep(2000L);
        NormalizedActionsEnvelope envelope = newApi.getNormalizedActions(null, null, mid, null, null, null, null, null);
        Assert.assertEquals((Object)new Long(1L), (Object)envelope.getSize());
        NormalizedAction normalized = (NormalizedAction)envelope.getData().get(0);
        Action actionRx = (Action)normalized.getData().getActions().get(0);
        Assert.assertEquals((Object)"setVolume", (Object)actionRx.getName());
        Object volume = actionRx.getParameters().get("volume");
        Assert.assertNotNull((String)"Volume should not be null", volume);
        Assert.assertEquals((Object)new Double(5.0), volume);
    }

    @Test
    public void testSendMessageActionAsync() throws Exception {
        MessageAction message = new MessageAction();
        message.setSdid("09174ee9e12644ec91f7ff4ed0e40700");
        message.setTs(new Long(System.currentTimeMillis()));
        message.setType("message");
        message.getData().put("volume", new Integer(500));
        final CountDownLatch lock = new CountDownLatch(1);
        final MessageIDEnvelope envelopeResult = new MessageIDEnvelope();
        this.apiClient.sendMessageActionAsync(message, (ApiCallback)new ApiCallback<MessageIDEnvelope>(){

            public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                e.printStackTrace();
                lock.countDown();
            }

            public void onSuccess(MessageIDEnvelope result, int statusCode, Map<String, List<String>> responseHeaders) {
                envelopeResult.setData(result.getData());
                lock.countDown();
            }

            public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                System.out.println("Upload progress bytesWritten=" + bytesWritten + ", contentLength=" + contentLength + ", done=" + done);
            }

            public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                System.out.println("Download progress bytesRead=" + bytesRead + ", contentLength=" + contentLength + ", done=" + done);
            }
        });
        boolean timeout = lock.await(60000L, TimeUnit.MILLISECONDS);
        if (envelopeResult.getData() != null) {
            String messageId = envelopeResult.getData().getMid();
            Assert.assertNotNull((String)"Message ID should not be null", (Object)messageId);
            NormalizedMessagesEnvelope envelope = this.apiClient.getNormalizedMessages(null, null, messageId, null, null, null, null, null, null, null);
            Assert.assertEquals((Object)new Long(1L), (Object)envelope.getSize());
            NormalizedMessage normalized = (NormalizedMessage)envelope.getData().get(0);
            Assert.assertEquals((Object)messageId, (Object)normalized.getMid());
            Object steps = normalized.getData().get("volume");
            Assert.assertNotNull((String)"Volume should not be null", steps);
            Assert.assertEquals((Object)new Double(500.0), steps);
        } else if (timeout) {
            Assert.fail((String)"timeout");
        } else {
            Assert.fail();
        }
    }
}

