/**
 * ARTIK Cloud API
 * No descripton provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package cloud.artik.api;

import cloud.artik.client.ApiCallback;
import cloud.artik.client.ApiClient;
import cloud.artik.client.ApiException;
import cloud.artik.client.ApiResponse;
import cloud.artik.client.Configuration;
import cloud.artik.client.Pair;
import cloud.artik.client.ProgressRequestBody;
import cloud.artik.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import cloud.artik.model.AggregatesHistogramResponse;
import cloud.artik.model.FieldPresenceEnvelope;
import cloud.artik.model.MessageAction;
import cloud.artik.model.NormalizedMessagesEnvelope;
import cloud.artik.model.AggregatesResponse;
import cloud.artik.model.SnapshotResponses;
import cloud.artik.model.NormalizedActionsEnvelope;
import cloud.artik.model.Actions;
import cloud.artik.model.MessageIDEnvelope;
import cloud.artik.model.Message;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessagesApi {
    private ApiClient apiClient;

    public MessagesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MessagesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /* Build call for getAggregatesHistogram */
    private com.squareup.okhttp.Call getAggregatesHistogramCall(Long startDate, Long endDate, String sdid, String field, String interval, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'startDate' is set
        if (startDate == null) {
            throw new ApiException("Missing the required parameter 'startDate' when calling getAggregatesHistogram(Async)");
        }
        
        // verify the required parameter 'endDate' is set
        if (endDate == null) {
            throw new ApiException("Missing the required parameter 'endDate' when calling getAggregatesHistogram(Async)");
        }
        

        // create path and map variables
        String localVarPath = "/messages/analytics/histogram".replaceAll("\\{format\\}","json");

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (startDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "startDate", startDate));
        if (endDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "endDate", endDate));
        if (sdid != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "sdid", sdid));
        if (field != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "field", field));
        if (interval != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "interval", interval));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "artikcloud_oauth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    /**
     * Get Normalized Message Histogram
     * Get Histogram on normalized messages.
     * @param startDate Timestamp of earliest message (in milliseconds since epoch). (required)
     * @param endDate Timestamp of latest message (in milliseconds since epoch). (required)
     * @param sdid Source device ID of the messages being searched. (optional)
     * @param field Message field being queried for building histogram. (optional)
     * @param interval Interval of time for building histogram blocks. (Valid values: minute, hour, day, month, year) (optional)
     * @return AggregatesHistogramResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AggregatesHistogramResponse getAggregatesHistogram(Long startDate, Long endDate, String sdid, String field, String interval) throws ApiException {
        ApiResponse<AggregatesHistogramResponse> resp = getAggregatesHistogramWithHttpInfo(startDate, endDate, sdid, field, interval);
        return resp.getData();
    }

    /**
     * Get Normalized Message Histogram
     * Get Histogram on normalized messages.
     * @param startDate Timestamp of earliest message (in milliseconds since epoch). (required)
     * @param endDate Timestamp of latest message (in milliseconds since epoch). (required)
     * @param sdid Source device ID of the messages being searched. (optional)
     * @param field Message field being queried for building histogram. (optional)
     * @param interval Interval of time for building histogram blocks. (Valid values: minute, hour, day, month, year) (optional)
     * @return ApiResponse&lt;AggregatesHistogramResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AggregatesHistogramResponse> getAggregatesHistogramWithHttpInfo(Long startDate, Long endDate, String sdid, String field, String interval) throws ApiException {
        com.squareup.okhttp.Call call = getAggregatesHistogramCall(startDate, endDate, sdid, field, interval, null, null);
        Type localVarReturnType = new TypeToken<AggregatesHistogramResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get Normalized Message Histogram (asynchronously)
     * Get Histogram on normalized messages.
     * @param startDate Timestamp of earliest message (in milliseconds since epoch). (required)
     * @param endDate Timestamp of latest message (in milliseconds since epoch). (required)
     * @param sdid Source device ID of the messages being searched. (optional)
     * @param field Message field being queried for building histogram. (optional)
     * @param interval Interval of time for building histogram blocks. (Valid values: minute, hour, day, month, year) (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAggregatesHistogramAsync(Long startDate, Long endDate, String sdid, String field, String interval, final ApiCallback<AggregatesHistogramResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAggregatesHistogramCall(startDate, endDate, sdid, field, interval, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AggregatesHistogramResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /* Build call for getFieldPresence */
    private com.squareup.okhttp.Call getFieldPresenceCall(Long startDate, Long endDate, String interval, String sdid, String fieldPresence, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'startDate' is set
        if (startDate == null) {
            throw new ApiException("Missing the required parameter 'startDate' when calling getFieldPresence(Async)");
        }
        
        // verify the required parameter 'endDate' is set
        if (endDate == null) {
            throw new ApiException("Missing the required parameter 'endDate' when calling getFieldPresence(Async)");
        }
        
        // verify the required parameter 'interval' is set
        if (interval == null) {
            throw new ApiException("Missing the required parameter 'interval' when calling getFieldPresence(Async)");
        }
        

        // create path and map variables
        String localVarPath = "/messages/presence".replaceAll("\\{format\\}","json");

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (sdid != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "sdid", sdid));
        if (fieldPresence != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "fieldPresence", fieldPresence));
        if (startDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "startDate", startDate));
        if (endDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "endDate", endDate));
        if (interval != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "interval", interval));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "artikcloud_oauth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    /**
     * Get normalized message presence
     * Get normalized message presence.
     * @param startDate startDate (required)
     * @param endDate endDate (required)
     * @param interval String representing grouping interval. One of: &#39;minute&#39; (1 hour limit), &#39;hour&#39; (1 day limit), &#39;day&#39; (31 days limit), &#39;month&#39; (1 year limit), or &#39;year&#39; (10 years limit). (required)
     * @param sdid Source device ID of the messages being searched. (optional)
     * @param fieldPresence String representing a field from the specified device ID. (optional)
     * @return FieldPresenceEnvelope
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FieldPresenceEnvelope getFieldPresence(Long startDate, Long endDate, String interval, String sdid, String fieldPresence) throws ApiException {
        ApiResponse<FieldPresenceEnvelope> resp = getFieldPresenceWithHttpInfo(startDate, endDate, interval, sdid, fieldPresence);
        return resp.getData();
    }

    /**
     * Get normalized message presence
     * Get normalized message presence.
     * @param startDate startDate (required)
     * @param endDate endDate (required)
     * @param interval String representing grouping interval. One of: &#39;minute&#39; (1 hour limit), &#39;hour&#39; (1 day limit), &#39;day&#39; (31 days limit), &#39;month&#39; (1 year limit), or &#39;year&#39; (10 years limit). (required)
     * @param sdid Source device ID of the messages being searched. (optional)
     * @param fieldPresence String representing a field from the specified device ID. (optional)
     * @return ApiResponse&lt;FieldPresenceEnvelope&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FieldPresenceEnvelope> getFieldPresenceWithHttpInfo(Long startDate, Long endDate, String interval, String sdid, String fieldPresence) throws ApiException {
        com.squareup.okhttp.Call call = getFieldPresenceCall(startDate, endDate, interval, sdid, fieldPresence, null, null);
        Type localVarReturnType = new TypeToken<FieldPresenceEnvelope>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get normalized message presence (asynchronously)
     * Get normalized message presence.
     * @param startDate startDate (required)
     * @param endDate endDate (required)
     * @param interval String representing grouping interval. One of: &#39;minute&#39; (1 hour limit), &#39;hour&#39; (1 day limit), &#39;day&#39; (31 days limit), &#39;month&#39; (1 year limit), or &#39;year&#39; (10 years limit). (required)
     * @param sdid Source device ID of the messages being searched. (optional)
     * @param fieldPresence String representing a field from the specified device ID. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFieldPresenceAsync(Long startDate, Long endDate, String interval, String sdid, String fieldPresence, final ApiCallback<FieldPresenceEnvelope> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFieldPresenceCall(startDate, endDate, interval, sdid, fieldPresence, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FieldPresenceEnvelope>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /* Build call for getLastNormalizedMessages */
    private com.squareup.okhttp.Call getLastNormalizedMessagesCall(Integer count, String sdids, String fieldPresence, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        

        // create path and map variables
        String localVarPath = "/messages/last".replaceAll("\\{format\\}","json");

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (count != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
        if (sdids != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "sdids", sdids));
        if (fieldPresence != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "fieldPresence", fieldPresence));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "artikcloud_oauth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    /**
     * Get Last Normalized Message
     * Get last messages normalized.
     * @param count Number of items to return per query. (optional)
     * @param sdids Comma separated list of source device IDs (minimum: 1). (optional)
     * @param fieldPresence String representing a field from the specified device ID. (optional)
     * @return NormalizedMessagesEnvelope
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public NormalizedMessagesEnvelope getLastNormalizedMessages(Integer count, String sdids, String fieldPresence) throws ApiException {
        ApiResponse<NormalizedMessagesEnvelope> resp = getLastNormalizedMessagesWithHttpInfo(count, sdids, fieldPresence);
        return resp.getData();
    }

    /**
     * Get Last Normalized Message
     * Get last messages normalized.
     * @param count Number of items to return per query. (optional)
     * @param sdids Comma separated list of source device IDs (minimum: 1). (optional)
     * @param fieldPresence String representing a field from the specified device ID. (optional)
     * @return ApiResponse&lt;NormalizedMessagesEnvelope&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<NormalizedMessagesEnvelope> getLastNormalizedMessagesWithHttpInfo(Integer count, String sdids, String fieldPresence) throws ApiException {
        com.squareup.okhttp.Call call = getLastNormalizedMessagesCall(count, sdids, fieldPresence, null, null);
        Type localVarReturnType = new TypeToken<NormalizedMessagesEnvelope>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get Last Normalized Message (asynchronously)
     * Get last messages normalized.
     * @param count Number of items to return per query. (optional)
     * @param sdids Comma separated list of source device IDs (minimum: 1). (optional)
     * @param fieldPresence String representing a field from the specified device ID. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getLastNormalizedMessagesAsync(Integer count, String sdids, String fieldPresence, final ApiCallback<NormalizedMessagesEnvelope> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getLastNormalizedMessagesCall(count, sdids, fieldPresence, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<NormalizedMessagesEnvelope>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /* Build call for getMessageAggregates */
    private com.squareup.okhttp.Call getMessageAggregatesCall(String sdid, String field, Long startDate, Long endDate, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'sdid' is set
        if (sdid == null) {
            throw new ApiException("Missing the required parameter 'sdid' when calling getMessageAggregates(Async)");
        }
        
        // verify the required parameter 'field' is set
        if (field == null) {
            throw new ApiException("Missing the required parameter 'field' when calling getMessageAggregates(Async)");
        }
        
        // verify the required parameter 'startDate' is set
        if (startDate == null) {
            throw new ApiException("Missing the required parameter 'startDate' when calling getMessageAggregates(Async)");
        }
        
        // verify the required parameter 'endDate' is set
        if (endDate == null) {
            throw new ApiException("Missing the required parameter 'endDate' when calling getMessageAggregates(Async)");
        }
        

        // create path and map variables
        String localVarPath = "/messages/analytics/aggregates".replaceAll("\\{format\\}","json");

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (sdid != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "sdid", sdid));
        if (field != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "field", field));
        if (startDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "startDate", startDate));
        if (endDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "endDate", endDate));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "artikcloud_oauth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    /**
     * Get Normalized Message Aggregates
     * Get Aggregates on normalized messages.
     * @param sdid Source device ID of the messages being searched. (required)
     * @param field Message field being queried for aggregates. (required)
     * @param startDate Timestamp of earliest message (in milliseconds since epoch). (required)
     * @param endDate Timestamp of latest message (in milliseconds since epoch). (required)
     * @return AggregatesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AggregatesResponse getMessageAggregates(String sdid, String field, Long startDate, Long endDate) throws ApiException {
        ApiResponse<AggregatesResponse> resp = getMessageAggregatesWithHttpInfo(sdid, field, startDate, endDate);
        return resp.getData();
    }

    /**
     * Get Normalized Message Aggregates
     * Get Aggregates on normalized messages.
     * @param sdid Source device ID of the messages being searched. (required)
     * @param field Message field being queried for aggregates. (required)
     * @param startDate Timestamp of earliest message (in milliseconds since epoch). (required)
     * @param endDate Timestamp of latest message (in milliseconds since epoch). (required)
     * @return ApiResponse&lt;AggregatesResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AggregatesResponse> getMessageAggregatesWithHttpInfo(String sdid, String field, Long startDate, Long endDate) throws ApiException {
        com.squareup.okhttp.Call call = getMessageAggregatesCall(sdid, field, startDate, endDate, null, null);
        Type localVarReturnType = new TypeToken<AggregatesResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get Normalized Message Aggregates (asynchronously)
     * Get Aggregates on normalized messages.
     * @param sdid Source device ID of the messages being searched. (required)
     * @param field Message field being queried for aggregates. (required)
     * @param startDate Timestamp of earliest message (in milliseconds since epoch). (required)
     * @param endDate Timestamp of latest message (in milliseconds since epoch). (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getMessageAggregatesAsync(String sdid, String field, Long startDate, Long endDate, final ApiCallback<AggregatesResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getMessageAggregatesCall(sdid, field, startDate, endDate, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AggregatesResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /* Build call for getMessageSnapshots */
    private com.squareup.okhttp.Call getMessageSnapshotsCall(String sdids, Boolean includeTimestamp, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'sdids' is set
        if (sdids == null) {
            throw new ApiException("Missing the required parameter 'sdids' when calling getMessageSnapshots(Async)");
        }
        

        // create path and map variables
        String localVarPath = "/messages/snapshots".replaceAll("\\{format\\}","json");

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (sdids != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "sdids", sdids));
        if (includeTimestamp != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "includeTimestamp", includeTimestamp));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "artikcloud_oauth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    /**
     * Get Message Snapshots
     * Get message snapshots.
     * @param sdids Device IDs for which the snapshots are requested. Max 100 device ids per call. (required)
     * @param includeTimestamp Indicates whether to return timestamps of the last update for each field. (optional)
     * @return SnapshotResponses
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SnapshotResponses getMessageSnapshots(String sdids, Boolean includeTimestamp) throws ApiException {
        ApiResponse<SnapshotResponses> resp = getMessageSnapshotsWithHttpInfo(sdids, includeTimestamp);
        return resp.getData();
    }

    /**
     * Get Message Snapshots
     * Get message snapshots.
     * @param sdids Device IDs for which the snapshots are requested. Max 100 device ids per call. (required)
     * @param includeTimestamp Indicates whether to return timestamps of the last update for each field. (optional)
     * @return ApiResponse&lt;SnapshotResponses&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SnapshotResponses> getMessageSnapshotsWithHttpInfo(String sdids, Boolean includeTimestamp) throws ApiException {
        com.squareup.okhttp.Call call = getMessageSnapshotsCall(sdids, includeTimestamp, null, null);
        Type localVarReturnType = new TypeToken<SnapshotResponses>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get Message Snapshots (asynchronously)
     * Get message snapshots.
     * @param sdids Device IDs for which the snapshots are requested. Max 100 device ids per call. (required)
     * @param includeTimestamp Indicates whether to return timestamps of the last update for each field. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getMessageSnapshotsAsync(String sdids, Boolean includeTimestamp, final ApiCallback<SnapshotResponses> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getMessageSnapshotsCall(sdids, includeTimestamp, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SnapshotResponses>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /* Build call for getNormalizedActions */
    private com.squareup.okhttp.Call getNormalizedActionsCall(String uid, String ddid, String mid, String offset, Integer count, Long startDate, Long endDate, String order, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        

        // create path and map variables
        String localVarPath = "/actions".replaceAll("\\{format\\}","json");

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (uid != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "uid", uid));
        if (ddid != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "ddid", ddid));
        if (mid != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "mid", mid));
        if (offset != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
        if (count != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
        if (startDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "startDate", startDate));
        if (endDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "endDate", endDate));
        if (order != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "artikcloud_oauth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    /**
     * Get Normalized Actions
     * Get the actions normalized
     * @param uid User ID. If not specified, assume that of the current authenticated user. If specified, it must be that of a user for which the current authenticated user has read access to. (optional)
     * @param ddid Destination device ID of the actions being searched. (optional)
     * @param mid The message ID being searched. (optional)
     * @param offset A string that represents the starting item, should be the value of &#39;next&#39; field received in the last response. (required for pagination) (optional)
     * @param count count (optional)
     * @param startDate startDate (optional)
     * @param endDate endDate (optional)
     * @param order Desired sort order: &#39;asc&#39; or &#39;desc&#39; (optional)
     * @return NormalizedActionsEnvelope
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public NormalizedActionsEnvelope getNormalizedActions(String uid, String ddid, String mid, String offset, Integer count, Long startDate, Long endDate, String order) throws ApiException {
        ApiResponse<NormalizedActionsEnvelope> resp = getNormalizedActionsWithHttpInfo(uid, ddid, mid, offset, count, startDate, endDate, order);
        return resp.getData();
    }

    /**
     * Get Normalized Actions
     * Get the actions normalized
     * @param uid User ID. If not specified, assume that of the current authenticated user. If specified, it must be that of a user for which the current authenticated user has read access to. (optional)
     * @param ddid Destination device ID of the actions being searched. (optional)
     * @param mid The message ID being searched. (optional)
     * @param offset A string that represents the starting item, should be the value of &#39;next&#39; field received in the last response. (required for pagination) (optional)
     * @param count count (optional)
     * @param startDate startDate (optional)
     * @param endDate endDate (optional)
     * @param order Desired sort order: &#39;asc&#39; or &#39;desc&#39; (optional)
     * @return ApiResponse&lt;NormalizedActionsEnvelope&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<NormalizedActionsEnvelope> getNormalizedActionsWithHttpInfo(String uid, String ddid, String mid, String offset, Integer count, Long startDate, Long endDate, String order) throws ApiException {
        com.squareup.okhttp.Call call = getNormalizedActionsCall(uid, ddid, mid, offset, count, startDate, endDate, order, null, null);
        Type localVarReturnType = new TypeToken<NormalizedActionsEnvelope>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get Normalized Actions (asynchronously)
     * Get the actions normalized
     * @param uid User ID. If not specified, assume that of the current authenticated user. If specified, it must be that of a user for which the current authenticated user has read access to. (optional)
     * @param ddid Destination device ID of the actions being searched. (optional)
     * @param mid The message ID being searched. (optional)
     * @param offset A string that represents the starting item, should be the value of &#39;next&#39; field received in the last response. (required for pagination) (optional)
     * @param count count (optional)
     * @param startDate startDate (optional)
     * @param endDate endDate (optional)
     * @param order Desired sort order: &#39;asc&#39; or &#39;desc&#39; (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getNormalizedActionsAsync(String uid, String ddid, String mid, String offset, Integer count, Long startDate, Long endDate, String order, final ApiCallback<NormalizedActionsEnvelope> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getNormalizedActionsCall(uid, ddid, mid, offset, count, startDate, endDate, order, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<NormalizedActionsEnvelope>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /* Build call for getNormalizedMessages */
    private com.squareup.okhttp.Call getNormalizedMessagesCall(String uid, String sdid, String mid, String fieldPresence, String filter, String offset, Integer count, Long startDate, Long endDate, String order, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        

        // create path and map variables
        String localVarPath = "/messages".replaceAll("\\{format\\}","json");

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (uid != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "uid", uid));
        if (sdid != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "sdid", sdid));
        if (mid != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "mid", mid));
        if (fieldPresence != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "fieldPresence", fieldPresence));
        if (filter != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "filter", filter));
        if (offset != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
        if (count != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
        if (startDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "startDate", startDate));
        if (endDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "endDate", endDate));
        if (order != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "artikcloud_oauth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    /**
     * Get Normalized Messages
     * Get the messages normalized
     * @param uid User ID. If not specified, assume that of the current authenticated user. If specified, it must be that of a user for which the current authenticated user has read access to. (optional)
     * @param sdid Source device ID of the messages being searched. (optional)
     * @param mid The message ID being searched. (optional)
     * @param fieldPresence String representing a field from the specified device ID. (optional)
     * @param filter Filter. (optional)
     * @param offset A string that represents the starting item, should be the value of &#39;next&#39; field received in the last response. (required for pagination) (optional)
     * @param count count (optional)
     * @param startDate startDate (optional)
     * @param endDate endDate (optional)
     * @param order Desired sort order: &#39;asc&#39; or &#39;desc&#39; (optional)
     * @return NormalizedMessagesEnvelope
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public NormalizedMessagesEnvelope getNormalizedMessages(String uid, String sdid, String mid, String fieldPresence, String filter, String offset, Integer count, Long startDate, Long endDate, String order) throws ApiException {
        ApiResponse<NormalizedMessagesEnvelope> resp = getNormalizedMessagesWithHttpInfo(uid, sdid, mid, fieldPresence, filter, offset, count, startDate, endDate, order);
        return resp.getData();
    }

    /**
     * Get Normalized Messages
     * Get the messages normalized
     * @param uid User ID. If not specified, assume that of the current authenticated user. If specified, it must be that of a user for which the current authenticated user has read access to. (optional)
     * @param sdid Source device ID of the messages being searched. (optional)
     * @param mid The message ID being searched. (optional)
     * @param fieldPresence String representing a field from the specified device ID. (optional)
     * @param filter Filter. (optional)
     * @param offset A string that represents the starting item, should be the value of &#39;next&#39; field received in the last response. (required for pagination) (optional)
     * @param count count (optional)
     * @param startDate startDate (optional)
     * @param endDate endDate (optional)
     * @param order Desired sort order: &#39;asc&#39; or &#39;desc&#39; (optional)
     * @return ApiResponse&lt;NormalizedMessagesEnvelope&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<NormalizedMessagesEnvelope> getNormalizedMessagesWithHttpInfo(String uid, String sdid, String mid, String fieldPresence, String filter, String offset, Integer count, Long startDate, Long endDate, String order) throws ApiException {
        com.squareup.okhttp.Call call = getNormalizedMessagesCall(uid, sdid, mid, fieldPresence, filter, offset, count, startDate, endDate, order, null, null);
        Type localVarReturnType = new TypeToken<NormalizedMessagesEnvelope>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get Normalized Messages (asynchronously)
     * Get the messages normalized
     * @param uid User ID. If not specified, assume that of the current authenticated user. If specified, it must be that of a user for which the current authenticated user has read access to. (optional)
     * @param sdid Source device ID of the messages being searched. (optional)
     * @param mid The message ID being searched. (optional)
     * @param fieldPresence String representing a field from the specified device ID. (optional)
     * @param filter Filter. (optional)
     * @param offset A string that represents the starting item, should be the value of &#39;next&#39; field received in the last response. (required for pagination) (optional)
     * @param count count (optional)
     * @param startDate startDate (optional)
     * @param endDate endDate (optional)
     * @param order Desired sort order: &#39;asc&#39; or &#39;desc&#39; (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getNormalizedMessagesAsync(String uid, String sdid, String mid, String fieldPresence, String filter, String offset, Integer count, Long startDate, Long endDate, String order, final ApiCallback<NormalizedMessagesEnvelope> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getNormalizedMessagesCall(uid, sdid, mid, fieldPresence, filter, offset, count, startDate, endDate, order, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<NormalizedMessagesEnvelope>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /* Build call for sendActions */
    private com.squareup.okhttp.Call sendActionsCall(Actions data, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = data;
        
        // verify the required parameter 'data' is set
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling sendActions(Async)");
        }
        

        // create path and map variables
        String localVarPath = "/actions".replaceAll("\\{format\\}","json");

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "artikcloud_oauth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    /**
     * Send Actions
     * Send Actions
     * @param data Actions that are passed in the body (required)
     * @return MessageIDEnvelope
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public MessageIDEnvelope sendActions(Actions data) throws ApiException {
        ApiResponse<MessageIDEnvelope> resp = sendActionsWithHttpInfo(data);
        return resp.getData();
    }

    /**
     * Send Actions
     * Send Actions
     * @param data Actions that are passed in the body (required)
     * @return ApiResponse&lt;MessageIDEnvelope&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<MessageIDEnvelope> sendActionsWithHttpInfo(Actions data) throws ApiException {
        com.squareup.okhttp.Call call = sendActionsCall(data, null, null);
        Type localVarReturnType = new TypeToken<MessageIDEnvelope>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Send Actions (asynchronously)
     * Send Actions
     * @param data Actions that are passed in the body (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call sendActionsAsync(Actions data, final ApiCallback<MessageIDEnvelope> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = sendActionsCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MessageIDEnvelope>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /* Build call for sendMessage */
    private com.squareup.okhttp.Call sendMessageCall(Message data, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = data;
        
        // verify the required parameter 'data' is set
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling sendMessage(Async)");
        }
        

        // create path and map variables
        String localVarPath = "/messages".replaceAll("\\{format\\}","json");

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "artikcloud_oauth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    /**
     * Send Message
     * Send a message
     * @param data Message object that is passed in the body (required)
     * @return MessageIDEnvelope
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public MessageIDEnvelope sendMessage(Message data) throws ApiException {
        ApiResponse<MessageIDEnvelope> resp = sendMessageWithHttpInfo(data);
        return resp.getData();
    }

    /**
     * Send Message
     * Send a message
     * @param data Message object that is passed in the body (required)
     * @return ApiResponse&lt;MessageIDEnvelope&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<MessageIDEnvelope> sendMessageWithHttpInfo(Message data) throws ApiException {
        com.squareup.okhttp.Call call = sendMessageCall(data, null, null);
        Type localVarReturnType = new TypeToken<MessageIDEnvelope>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Send Message (asynchronously)
     * Send a message
     * @param data Message object that is passed in the body (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call sendMessageAsync(Message data, final ApiCallback<MessageIDEnvelope> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = sendMessageCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MessageIDEnvelope>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    
    /* Build call for sendMessageAction */
    @Deprecated
    private com.squareup.okhttp.Call sendMessageActionCall(MessageAction data, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = data;
        
        // verify the required parameter 'data' is set
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling sendMessageAction(Async)");
        }
        

        // create path and map variables
        String localVarPath = "/messages".replaceAll("\\{format\\}","json");

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "artikcloud_oauth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    /**
     * Send Message Action
     * (Deprecated) Send a message or an Action:&lt;br/&gt;&lt;table&gt;&lt;tr&gt;&lt;th&gt;Combination&lt;/th&gt;&lt;th&gt;Parameters&lt;/th&gt;&lt;th&gt;Description&lt;/th&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;Send Message&lt;/td&gt;&lt;td&gt;sdid, type&#x3D;message&lt;/td&gt;&lt;td&gt;Send a message from a Source Device&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;Send Action&lt;/td&gt;&lt;td&gt;ddid, type&#x3D;action&lt;/td&gt;&lt;td&gt;Send an action to a Destination Device&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;Common&lt;/td&gt;&lt;td&gt;data, ts, token&lt;/td&gt;&lt;td&gt;Parameters that can be used with the above combinations.&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;
     * @param data Message or Action object that is passed in the body (required)
     * @return MessageIDEnvelope
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    @Deprecated
    public MessageIDEnvelope sendMessageAction(MessageAction data) throws ApiException {
        ApiResponse<MessageIDEnvelope> resp = sendMessageActionWithHttpInfo(data);
        return resp.getData();
    }

    /**
     * Send Message Action
     * (Deprecated) Send a message or an Action:&lt;br/&gt;&lt;table&gt;&lt;tr&gt;&lt;th&gt;Combination&lt;/th&gt;&lt;th&gt;Parameters&lt;/th&gt;&lt;th&gt;Description&lt;/th&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;Send Message&lt;/td&gt;&lt;td&gt;sdid, type&#x3D;message&lt;/td&gt;&lt;td&gt;Send a message from a Source Device&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;Send Action&lt;/td&gt;&lt;td&gt;ddid, type&#x3D;action&lt;/td&gt;&lt;td&gt;Send an action to a Destination Device&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;Common&lt;/td&gt;&lt;td&gt;data, ts, token&lt;/td&gt;&lt;td&gt;Parameters that can be used with the above combinations.&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;
     * @param data Message or Action object that is passed in the body (required)
     * @return ApiResponse&lt;MessageIDEnvelope&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    @Deprecated
    public ApiResponse<MessageIDEnvelope> sendMessageActionWithHttpInfo(MessageAction data) throws ApiException {
        com.squareup.okhttp.Call call = sendMessageActionCall(data, null, null);
        Type localVarReturnType = new TypeToken<MessageIDEnvelope>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Send Message Action (asynchronously)
     * (Deprecated) Send a message or an Action:&lt;br/&gt;&lt;table&gt;&lt;tr&gt;&lt;th&gt;Combination&lt;/th&gt;&lt;th&gt;Parameters&lt;/th&gt;&lt;th&gt;Description&lt;/th&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;Send Message&lt;/td&gt;&lt;td&gt;sdid, type&#x3D;message&lt;/td&gt;&lt;td&gt;Send a message from a Source Device&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;Send Action&lt;/td&gt;&lt;td&gt;ddid, type&#x3D;action&lt;/td&gt;&lt;td&gt;Send an action to a Destination Device&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;Common&lt;/td&gt;&lt;td&gt;data, ts, token&lt;/td&gt;&lt;td&gt;Parameters that can be used with the above combinations.&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;
     * @param data Message or Action object that is passed in the body (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    @Deprecated
    public com.squareup.okhttp.Call sendMessageActionAsync(MessageAction data, final ApiCallback<MessageIDEnvelope> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = sendMessageActionCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MessageIDEnvelope>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }    
}
