/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.api;

import cloud.artik.api.TokensApi;
import cloud.artik.client.ApiClient;
import cloud.artik.model.CheckTokenResponse;
import cloud.artik.model.RefreshTokenResponse;
import cloud.artik.model.TokenRequest;
import org.junit.Assert;
import org.junit.Test;

public class TokensApiTest {
    protected String basePath = "https://accounts.artik.cloud";

    protected TokensApi api(String accessToken) {
        try {
            ApiClient client = new ApiClient();
            client.setAccessToken(accessToken);
            client.setBasePath(this.basePath);
            client.setDebugging(true);
            TokensApi retVal = new TokensApi();
            retVal.setApiClient(client);
            return retVal;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    @Test
    public void testCheckToken() throws Exception {
        String userAccessToken = "6907fe156b6848fa82395b2b99a882ed";
        TokensApi apiClient = this.api(userAccessToken);
        TokenRequest request = new TokenRequest();
        request.setToken(userAccessToken);
        CheckTokenResponse checkTokenResponse = apiClient.checkToken(request);
        Assert.assertNotNull((Object)checkTokenResponse);
        Assert.assertEquals((Object)"Valid token", (Object)checkTokenResponse.getData().getMessage());
    }

    @Test
    public void testRefreshToken() throws Exception {
        String userAccessToken = "6907fe156b6848fa82395b2b99a882ed";
        String refreshToken = "bb90333aee114b3e97284814d978080d";
        TokensApi apiClient = this.api(userAccessToken);
        RefreshTokenResponse refreshTokenResponse = apiClient.refreshToken("refresh_token", refreshToken);
        Assert.assertNotNull((Object)refreshTokenResponse);
    }
}

