/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.api;

import cloud.artik.api.MessagesApi;
import cloud.artik.client.ApiClient;
import cloud.artik.model.MessageAction;
import cloud.artik.model.NormalizedMessage;
import cloud.artik.model.NormalizedMessagesEnvelope;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessagesApiTest {
    protected MessagesApi apiClient = null;

    protected MessagesApi api(String deviceToken) {
        try {
            ApiClient client = new ApiClient();
            client.setAccessToken(deviceToken);
            client.setDebugging(true);
            MessagesApi retVal = new MessagesApi();
            retVal.setApiClient(client);
            return retVal;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    @Before
    public void setUp() throws Exception {
        String deviceToken = "1eef3e3251e147d1ac707a57f6779c49";
        this.apiClient = this.api(deviceToken);
    }

    @After
    public void tearDown() throws Exception {
        this.apiClient = null;
    }

    @Test
    public void testSendMessageAction() throws Exception {
        MessageAction message = new MessageAction();
        message.setSdid("993925c3cd994bf7a51c620884be65e9");
        message.setTs(new Long(System.currentTimeMillis()));
        message.setType("message");
        message.getData().put("volume", new Integer(5));
        String messageId = this.apiClient.sendMessageAction(message).getData().getMid();
        Assert.assertNotNull((String)"Message ID should not be null", (Object)messageId);
        Thread.sleep(2000L);
        NormalizedMessagesEnvelope envelope = this.apiClient.getNormalizedMessages(null, null, messageId, null, null, null, null, null, null, null);
        Assert.assertEquals((Object)new Long(1L), (Object)envelope.getSize());
        NormalizedMessage normalized = (NormalizedMessage)envelope.getData().get(0);
        Assert.assertEquals((Object)messageId, (Object)normalized.getMid());
        Object volume = normalized.getData().get("volume");
        Assert.assertNotNull((String)"Volume should not be null", volume);
        Assert.assertEquals((Object)new Double(5.0), volume);
    }
}

