/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.core.rules.ruleset.impl;

import cloud.altemista.fwk.common.util.DefensiveUtil;
import cloud.altemista.fwk.core.rules.ruleset.RulesetContainer;
import cloud.altemista.fwk.core.rules.ruleset.RulesetContainerResolver;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.Assert;

public class NameBasedRulesetContainerResolverImpl<C>
implements RulesetContainerResolver<C> {
    private Map<String, RulesetContainer<C>> containerMap;
    private RulesetContainer<C> fallbackContainer;

    public NameBasedRulesetContainerResolverImpl(Map<String, RulesetContainer<C>> containerMap) {
        Assert.notNull(containerMap);
        this.containerMap = (Map)ObjectUtils.defaultIfNull((Object)DefensiveUtil.unmodifiableMap(containerMap), Collections.emptyMap());
    }

    @Override
    public RulesetContainer<C> getDefaultRulesetContainer() {
        for (RulesetContainer<C> container : this.containerMap.values()) {
            if (!container.isDefaultContainer()) continue;
            return container;
        }
        return this.fallbackContainer.isDefaultContainer() ? this.fallbackContainer : null;
    }

    @Override
    public RulesetContainer<C> getRulesetContainer(String logicalName) {
        return (RulesetContainer)ObjectUtils.defaultIfNull(this.containerMap.get(logicalName), this.fallbackContainer);
    }

    public void setFallbackRulesetResolver(RulesetContainer<C> fallbackResolver) {
        this.fallbackContainer = fallbackResolver;
    }
}

