/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.core.rules.impl;

import cloud.altemista.fwk.core.rules.RulesService;
import cloud.altemista.fwk.core.rules.exception.RulesEngineException;
import cloud.altemista.fwk.core.rules.ruleset.Ruleset;
import cloud.altemista.fwk.core.rules.ruleset.RulesetContainer;
import cloud.altemista.fwk.core.rules.ruleset.RulesetContainerResolver;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public abstract class AbstractRulesServiceImpl<C>
implements RulesService {
    private RulesetContainerResolver<C> rulesetContainerResolver;

    public AbstractRulesServiceImpl(RulesetContainerResolver<C> rulesetContainerResolver) {
        Assert.notNull(rulesetContainerResolver);
        this.rulesetContainerResolver = rulesetContainerResolver;
    }

    @Override
    public <T> T executeRules(T input) {
        Ruleset defaultRuleset = this.defaultRuleset();
        if (defaultRuleset == null) {
            throw new RulesEngineException("no_default_ruleset");
        }
        return defaultRuleset.executeRules(input);
    }

    @Override
    public <T> List<T> executeRules(List<T> input) {
        Ruleset defaultRuleset = this.defaultRuleset();
        if (defaultRuleset == null) {
            throw new RulesEngineException("no_default_ruleset");
        }
        return defaultRuleset.executeRules(input);
    }

    protected C getDefaultContainer() {
        RulesetContainer<C> defaultRulesetContainer = this.rulesetContainerResolver.getDefaultRulesetContainer();
        if (defaultRulesetContainer == null) {
            throw new RulesEngineException("no_default_ruleset");
        }
        return defaultRulesetContainer.getContainer();
    }

    protected C getContainer(String logicalName) {
        if (StringUtils.isEmpty((CharSequence)logicalName)) {
            return this.getDefaultContainer();
        }
        RulesetContainer<C> rulesetContainer = this.rulesetContainerResolver.getRulesetContainer(logicalName);
        if (rulesetContainer == null) {
            throw new RulesEngineException("invalid_ruleset", new Object[]{logicalName});
        }
        return rulesetContainer.getContainer();
    }
}

