/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.rules.drools.resolver.impl;

import cloud.altemista.fwk.core.rules.exception.RulesEngineException;
import cloud.altemista.fwk.core.rules.ruleset.RulesetContainer;
import cloud.altemista.fwk.core.rules.ruleset.impl.AbstractRulesetContainerImpl;
import cloud.altemista.fwk.rules.drools.resolver.impl.DirectoryClassPathResource;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.drools.core.io.impl.FileSystemResource;
import org.drools.core.io.impl.InputStreamResource;
import org.drools.core.io.impl.UrlResource;
import org.drools.core.io.internal.InternalResource;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DroolsUrlRulesetContainerImpl
extends AbstractRulesetContainerImpl<KieContainer>
implements RulesetContainer<KieContainer>,
InitializingBean {
    private String url;
    private String username;
    private String password;
    private boolean basicAuthentication;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.url);
    }

    protected KieContainer initContainer() {
        if (StringUtils.startsWith((CharSequence)this.url, (CharSequence)"classpath:")) {
            return this.initClasspathKieContainer();
        }
        if (StringUtils.startsWith((CharSequence)this.url, (CharSequence)"file:")) {
            return this.initFileSystemKieContainer();
        }
        return this.initUrlKieContainer();
    }

    private KieContainer initClasspathKieContainer() {
        String path = StringUtils.removeStart((String)this.url, (String)"classpath:");
        return this.initKieContainer((InternalResource)new DirectoryClassPathResource(path));
    }

    private KieContainer initFileSystemKieContainer() {
        KieServices kieServices = KieServices.Factory.get();
        String path = StringUtils.removeStart((String)this.url, (String)"file:");
        return this.initKieContainer((InternalResource)((FileSystemResource)kieServices.getResources().newFileSystemResource(path)));
    }

    private KieContainer initUrlKieContainer() {
        KieServices kieServices = KieServices.Factory.get();
        UrlResource urlResource = (UrlResource)kieServices.getResources().newUrlResource(this.url);
        if (StringUtils.isNotEmpty((CharSequence)this.username)) {
            urlResource.setUsername(this.username);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.password)) {
            urlResource.setPassword(this.password);
        }
        if (this.basicAuthentication) {
            urlResource.setBasicAuthentication("enabled");
        }
        InputStream inputStream = null;
        try {
            inputStream = urlResource.getInputStream();
            KieContainer kieContainer = this.initKieContainer((InternalResource)((InputStreamResource)kieServices.getResources().newInputStreamResource(inputStream)));
            return kieContainer;
        }
        catch (IOException e) {
            throw new RulesEngineException("io_exception", new Object[]{this.url}, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private KieContainer initKieContainer(InternalResource internalResource) {
        KieServices kieServices = KieServices.Factory.get();
        KieModule kieModule = kieServices.getRepository().addKieModule((Resource)internalResource, new Resource[0]);
        return kieServices.newKieContainer(kieModule.getReleaseId());
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBasicAuthentication(boolean basicAuthentication) {
        this.basicAuthentication = basicAuthentication;
    }
}

