/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.rules.drools.impl;

import cloud.altemista.fwk.core.rules.RulesService;
import cloud.altemista.fwk.core.rules.exception.RulesEngineException;
import cloud.altemista.fwk.core.rules.impl.AbstractRulesServiceImpl;
import cloud.altemista.fwk.core.rules.ruleset.Ruleset;
import cloud.altemista.fwk.core.rules.ruleset.RulesetContainerResolver;
import cloud.altemista.fwk.rules.drools.impl.DroolsRulesetImpl;
import org.kie.api.KieBase;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.runtime.KieContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsRulesServiceImpl
extends AbstractRulesServiceImpl<KieContainer>
implements RulesService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DroolsRulesServiceImpl.class);

    public DroolsRulesServiceImpl(RulesetContainerResolver<KieContainer> rulesetContainerResolver) {
        super(rulesetContainerResolver);
    }

    public Ruleset defaultRuleset() {
        KieContainer kieContainer = (KieContainer)this.getDefaultContainer();
        try {
            KieBase defaultKieBase = kieContainer.getKieBase();
            return new DroolsRulesetImpl(defaultKieBase);
        }
        catch (RuntimeException e) {
            throw new RulesEngineException("no_default_ruleset", (Throwable)e);
        }
    }

    public Ruleset getRuleset(String logicalName) {
        KieContainer kieContainer = this.getContainer(logicalName);
        try {
            KieBase kieBase = kieContainer.getKieBase(logicalName);
            return new DroolsRulesetImpl(kieBase);
        }
        catch (RuntimeException e) {
            throw new RulesEngineException("invalid_ruleset", new Object[]{logicalName}, (Throwable)e);
        }
    }

    protected KieContainer getContainer(String logicalName) {
        KieContainer container = (KieContainer)super.getContainer(logicalName);
        Results rulesVerification = container.verify();
        String format = "Loading rule set {}: {}";
        for (Message msg : rulesVerification.getMessages()) {
            switch (msg.getLevel()) {
                case ERROR: {
                    LOGGER.error(format, (Object)logicalName, (Object)msg.getText());
                    break;
                }
                case WARNING: {
                    LOGGER.warn(format, (Object)logicalName, (Object)msg.getText());
                    break;
                }
                case INFO: {
                    LOGGER.info(format, (Object)logicalName, (Object)msg.getText());
                }
            }
        }
        if (rulesVerification.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RulesEngineException("malformed_ruleset", new Object[]{logicalName});
        }
        return container;
    }
}

