/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.rules.drools.resolver.impl;

import cloud.altemista.fwk.core.rules.ruleset.RulesetContainer;
import cloud.altemista.fwk.core.rules.ruleset.impl.AbstractRulesetContainerImpl;
import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DroolsRepositoryRulesetContainerImpl
extends AbstractRulesetContainerImpl<KieContainer>
implements RulesetContainer<KieContainer>,
InitializingBean {
    private String groupId;
    private String artifactId;
    private String version = "LATEST";
    private boolean enableScanner;
    private long scannerInterval;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.groupId);
        Assert.notNull((Object)this.artifactId);
        Assert.notNull((Object)this.artifactId);
        if (this.enableScanner) {
            Assert.isTrue((this.scannerInterval > 0L ? 1 : 0) != 0, (String)"scannerInterval must be positive");
        }
    }

    protected KieContainer initContainer() {
        KieServices kieServices = KieServices.Factory.get();
        ReleaseId releaseId = kieServices.newReleaseId(this.groupId, this.artifactId, this.version);
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        if (this.enableScanner) {
            KieScanner kieScanner = kieServices.newKieScanner(kieContainer);
            kieScanner.start(this.scannerInterval);
        }
        return kieContainer;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setEnableScanner(boolean enableScanner) {
        this.enableScanner = enableScanner;
    }

    public void setScannerInterval(long scannerInterval) {
        this.scannerInterval = scannerInterval;
    }
}

