/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.rules.drools.impl;

import cloud.altemista.fwk.core.rules.session.StatelessRuleSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.command.CommandFactory;

public class DroolsStatelessRuleSessionImpl
implements StatelessRuleSession {
    private static final String INPUT_ID_FORMAT = "input#%d";
    private StatelessKieSession statelessKieSession;

    public DroolsStatelessRuleSessionImpl(StatelessKieSession statelessKieSession) {
        this.statelessKieSession = statelessKieSession;
    }

    public <T> T executeRules(T input) {
        if (input == null) {
            return null;
        }
        this.statelessKieSession.execute(CommandFactory.newInsert(input));
        return input;
    }

    public <T> List<T> executeRules(List<T> inputs) {
        if (inputs == null) {
            return null;
        }
        if (inputs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> identifiers = new ArrayList<String>();
        ArrayList<Command> inputCommands = new ArrayList<Command>();
        int index = 0;
        for (T input : inputs) {
            String identifier = String.format(INPUT_ID_FORMAT, index++);
            identifiers.add(identifier);
            inputCommands.add(CommandFactory.newInsert(input, (String)identifier));
        }
        BatchExecutionCommand batchExecutionCommand = CommandFactory.newBatchExecution(inputCommands);
        ExecutionResults executionResults = (ExecutionResults)this.statelessKieSession.execute((Command)batchExecutionCommand);
        ArrayList<Object> outputs = new ArrayList<Object>();
        for (String identifier : identifiers) {
            outputs.add(executionResults.getValue(identifier));
        }
        return outputs;
    }
}

