/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.rules.drools.impl;

import cloud.altemista.fwk.core.rules.session.StatefulRuleSession;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.springframework.util.Assert;

public class DroolsStatefulRuleSessionImpl
implements StatefulRuleSession {
    private KieSession kieSession;
    private Map<String, FactHandle> factHandleMap;

    public DroolsStatefulRuleSessionImpl(KieSession kieSession) {
        Assert.notNull((Object)kieSession);
        this.kieSession = kieSession;
        this.factHandleMap = new HashMap<String, FactHandle>();
    }

    public void release() {
        this.kieSession.dispose();
    }

    public void executeRules() {
        this.kieSession.fireAllRules();
    }

    public String addObject(Object bean) {
        if (bean == null) {
            return null;
        }
        FactHandle handle = this.kieSession.insert(bean);
        String id = handle.toExternalForm();
        this.factHandleMap.put(id, handle);
        return id;
    }

    public Object getObject(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        FactHandle handle = this.factHandleMap.get(id);
        if (handle == null) {
            return null;
        }
        return this.kieSession.getObject(handle);
    }

    public Map<String, Object> getObjects() {
        HashMap<String, Object> beans = new HashMap<String, Object>();
        for (Map.Entry<String, FactHandle> entry : this.factHandleMap.entrySet()) {
            beans.put(entry.getKey(), this.kieSession.getObject(entry.getValue()));
        }
        return beans;
    }

    public void removeObject(String id) {
        FactHandle handle;
        if (StringUtils.isNotEmpty((CharSequence)id) && (handle = this.factHandleMap.get(id)) != null) {
            this.kieSession.delete(handle);
            this.factHandleMap.remove(id);
        }
    }

    public void updateObject(String id, Object bean) {
        FactHandle handle;
        if (bean == null) {
            this.removeObject(id);
        }
        if (StringUtils.isNotEmpty((CharSequence)id) && (handle = this.factHandleMap.get(id)) != null) {
            this.kieSession.update(handle, bean);
        }
    }

    public void reset() {
        Iterator<FactHandle> it = this.factHandleMap.values().iterator();
        while (it.hasNext()) {
            this.kieSession.delete(it.next());
            it.remove();
        }
        this.factHandleMap.clear();
    }

    public void addGlobal(String id, Object value) {
        if (StringUtils.isNotEmpty((CharSequence)id) && value != null) {
            this.kieSession.setGlobal(id, value);
        }
    }

    public Object getGlobal(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        return this.kieSession.getGlobal(id);
    }

    public Map<String, Object> getGlobals() {
        Globals droolsGlobals = this.kieSession.getGlobals();
        Iterator it = droolsGlobals.getGlobalKeys().iterator();
        HashMap<String, Object> globals = new HashMap<String, Object>();
        while (it.hasNext()) {
            String key = (String)it.next();
            globals.put(key, droolsGlobals.get(key));
        }
        return globals;
    }
}

