/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.core.rest.security;

import java.io.IOException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;

public class BasicClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final Credentials credentials;

    public BasicClientHttpRequestInterceptor(Credentials credentials) {
        Assert.notNull((Object)credentials, (String)"The credentials must not be null");
        this.credentials = credentials;
    }

    public BasicClientHttpRequestInterceptor(String username, String password) {
        Assert.hasText((String)username, (String)"The user name must not be null nor empty");
        this.credentials = new UsernamePasswordCredentials(username, password);
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        byte[] usernameAndPassword = String.format("%s:%s", this.credentials.getUserPrincipal().getName(), this.credentials.getPassword()).getBytes("UTF-8");
        String authorization = String.format("Basic %s", Base64Utils.encodeToString((byte[])usernameAndPassword));
        request.getHeaders().add("Authorization", authorization);
        return execution.execute(request, body);
    }
}

