/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.core.rest.security;

import java.io.IOException;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class DigestAuthRestTemplate
extends RestTemplate {
    private final Credentials credentials;

    public DigestAuthRestTemplate(Credentials credentials) {
        Assert.notNull((Object)credentials, (String)"The credentials must not be null");
        this.credentials = credentials;
        this.setErrorHandler(new DigestResponseErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler()));
    }

    public DigestAuthRestTemplate(String username, String password) {
        Assert.hasText((String)username, (String)"The user name must not be null nor empty");
        this.credentials = new UsernamePasswordCredentials(username, password);
        this.setErrorHandler(new DigestResponseErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler()));
    }

    public void setErrorHandler(ResponseErrorHandler errorHandler) {
        Assert.notNull((Object)errorHandler, (String)"The ResponseErrorHandler must not be null");
        if (errorHandler instanceof DigestResponseErrorHandler) {
            super.setErrorHandler(errorHandler);
        } else {
            super.setErrorHandler((ResponseErrorHandler)new DigestResponseErrorHandler(errorHandler));
        }
    }

    protected <T> T doExecute(URI url, HttpMethod method, RequestCallback pRequestCallback, ResponseExtractor<T> responseExtractor) {
        try {
            return (T)super.doExecute(url, method, pRequestCallback, responseExtractor);
        }
        catch (UnauthorizedException unauthorizedException) {
            try {
                Header solutionHeader = this.createSolution(url, method, unauthorizedException.getChallenge());
                DigestRequestCallback requestCallback = new DigestRequestCallback(pRequestCallback, solutionHeader);
                return (T)super.doExecute(url, method, (RequestCallback)requestCallback, responseExtractor);
            }
            catch (MalformedChallengeException e) {
                throw new RestClientException(e.getMessage(), (Throwable)e);
            }
            catch (AuthenticationException e) {
                throw new RestClientException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected Header createSolution(URI url, HttpMethod method, String challenge) throws MalformedChallengeException, AuthenticationException {
        DigestScheme digestSolutionProvider = new DigestScheme();
        digestSolutionProvider.processChallenge((Header)new BasicHeader("WWW-Authenticate", challenge));
        return digestSolutionProvider.authenticate(this.credentials, (HttpRequest)new BasicHttpRequest(method.name(), url.getPath()), (HttpContext)new BasicHttpContext());
    }

    protected static class UnauthorizedException
    extends RestClientException {
        private static final long serialVersionUID = -8910130988417144547L;
        private final String challenge;

        public UnauthorizedException(String challenge) {
            super("unauthorized");
            this.challenge = challenge;
        }

        public String getChallenge() {
            return this.challenge;
        }
    }

    protected static class DigestResponseErrorHandler
    implements ResponseErrorHandler {
        private ResponseErrorHandler wrapped;

        public DigestResponseErrorHandler(ResponseErrorHandler wrapped) {
            Assert.notNull((Object)wrapped, (String)"The wrapped ResponseErrorHandler must not be null");
            this.wrapped = wrapped;
        }

        public boolean hasError(ClientHttpResponse response) throws IOException {
            return HttpStatus.UNAUTHORIZED.equals((Object)response.getStatusCode()) || this.wrapped.hasError(response);
        }

        public void handleError(ClientHttpResponse response) throws IOException {
            if (HttpStatus.UNAUTHORIZED.equals((Object)response.getStatusCode())) {
                for (String challenge : response.getHeaders().get((Object)"WWW-Authenticate")) {
                    if (challenge == null) continue;
                    throw new UnauthorizedException(challenge);
                }
            }
            this.wrapped.handleError(response);
        }
    }

    protected static class DigestRequestCallback
    implements RequestCallback {
        private RequestCallback wrapped;
        private Header solutionHeader;

        public DigestRequestCallback(RequestCallback wrapped, Header solutionHeader) {
            this.wrapped = wrapped;
            this.solutionHeader = solutionHeader;
        }

        public void doWithRequest(ClientHttpRequest request) throws IOException {
            request.getHeaders().add(this.solutionHeader.getName(), this.solutionHeader.getValue());
            if (this.wrapped != null) {
                this.wrapped.doWithRequest(request);
            }
        }
    }
}

