/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.test.util;

import cloud.altemista.fwk.common.model.ByteArrayContentReadable;
import cloud.altemista.fwk.common.model.ContentReadable;
import cloud.altemista.fwk.common.model.ResourceContentReadable;
import cloud.altemista.fwk.common.model.StreamContentReadable;
import cloud.altemista.fwk.common.model.StreamSourceContentReadable;
import cloud.altemista.fwk.test.util.SlowByteArrayInputStream;
import cloud.altemista.fwk.test.util.SlowInputStreamSource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.springframework.core.io.InputStreamSource;
import org.springframework.util.Base64Utils;

public final class TestConstants {
    public static final String TEXT = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum";
    public static final String BINARY_BASE64 = "/9j/4AAQSkZJRgABAQAAAQABAAD//gA7Q1JFQVRPUjogZ2QtanBlZyB2MS4wICh1c2luZyBJSkcgSlBFRyB2NjIpLCBxdWFsaXR5ID0gNzAK/9sAQwAKBwcIBwYKCAgICwoKCw4YEA4NDQ4dFRYRGCMfJSQiHyIhJis3LyYpNCkhIjBBMTQ5Oz4+PiUuRElDPEg3PT47/9sAQwEKCwsODQ4cEBAcOygiKDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7/8AAEQgAIAAgAwEiAAIRAQMRAf/EAB8AAAEFAQEBAQEBAAAAAAAAAAABAgMEBQYHCAkKC//EALUQAAIBAwMCBAMFBQQEAAABfQECAwAEEQUSITFBBhNRYQcicRQygZGhCCNCscEVUtHwJDNicoIJChYXGBkaJSYnKCkqNDU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6g4SFhoeIiYqSk5SVlpeYmZqio6Slpqeoqaqys7S1tre4ubrCw8TFxsfIycrS09TV1tfY2drh4uPk5ebn6Onq8fLz9PX29/j5+v/EAB8BAAMBAQEBAQEBAQEAAAAAAAABAgMEBQYHCAkKC//EALURAAIBAgQEAwQHBQQEAAECdwABAgMRBAUhMQYSQVEHYXETIjKBCBRCkaGxwQkjM1LwFWJy0QoWJDThJfEXGBkaJicoKSo1Njc4OTpDREVGR0hJSlNUVVZXWFlaY2RlZmdoaWpzdHV2d3h5eoKDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uLj5OXm5+jp6vLz9PX29/j5+v/aAAwDAQACEQMRAD8Adc3Kxdc8dTg4X61RWeedQwJUNjqcAZOMj1qxYWKX1lcXjCSaVdqxmNW2nvnrgnkjngYpkttdxylJFEIOdrcEFvT0ANecrXsepdibplJx04z82SO345pyTeZkEYIJBGOn1pXjbkxybs4wrYHGMk/rUIPmoGTsO3f296dhpmt4c8UjU5Xt47ZYXRRiINkEeoq9LaedNLA9wziUljtx+7PGMccday9L8GRaZcfa/tU8s0fKmM7PwrYe5uooJNgCnoEDBm+p+tc01aXuGkE5R94x7nS5rWZoQxdcAqH5NV1gdXYlywY5xnH8quarFNfmC5ThlTa+5wGwSOnv1qNYb+MMGkjkQrleoJOOB6D8K0UpF+ziluf/2Q==";
    public static final byte[] BINARY = Base64Utils.decodeFromString((String)"/9j/4AAQSkZJRgABAQAAAQABAAD//gA7Q1JFQVRPUjogZ2QtanBlZyB2MS4wICh1c2luZyBJSkcgSlBFRyB2NjIpLCBxdWFsaXR5ID0gNzAK/9sAQwAKBwcIBwYKCAgICwoKCw4YEA4NDQ4dFRYRGCMfJSQiHyIhJis3LyYpNCkhIjBBMTQ5Oz4+PiUuRElDPEg3PT47/9sAQwEKCwsODQ4cEBAcOygiKDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7/8AAEQgAIAAgAwEiAAIRAQMRAf/EAB8AAAEFAQEBAQEBAAAAAAAAAAABAgMEBQYHCAkKC//EALUQAAIBAwMCBAMFBQQEAAABfQECAwAEEQUSITFBBhNRYQcicRQygZGhCCNCscEVUtHwJDNicoIJChYXGBkaJSYnKCkqNDU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6g4SFhoeIiYqSk5SVlpeYmZqio6Slpqeoqaqys7S1tre4ubrCw8TFxsfIycrS09TV1tfY2drh4uPk5ebn6Onq8fLz9PX29/j5+v/EAB8BAAMBAQEBAQEBAQEAAAAAAAABAgMEBQYHCAkKC//EALURAAIBAgQEAwQHBQQEAAECdwABAgMRBAUhMQYSQVEHYXETIjKBCBRCkaGxwQkjM1LwFWJy0QoWJDThJfEXGBkaJicoKSo1Njc4OTpDREVGR0hJSlNUVVZXWFlaY2RlZmdoaWpzdHV2d3h5eoKDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uLj5OXm5+jp6vLz9PX29/j5+v/aAAwDAQACEQMRAD8Adc3Kxdc8dTg4X61RWeedQwJUNjqcAZOMj1qxYWKX1lcXjCSaVdqxmNW2nvnrgnkjngYpkttdxylJFEIOdrcEFvT0ANecrXsepdibplJx04z82SO345pyTeZkEYIJBGOn1pXjbkxybs4wrYHGMk/rUIPmoGTsO3f296dhpmt4c8UjU5Xt47ZYXRRiINkEeoq9LaedNLA9wziUljtx+7PGMccday9L8GRaZcfa/tU8s0fKmM7PwrYe5uooJNgCnoEDBm+p+tc01aXuGkE5R94x7nS5rWZoQxdcAqH5NV1gdXYlywY5xnH8quarFNfmC5ThlTa+5wGwSOnv1qNYb+MMGkjkQrleoJOOB6D8K0UpF+ziluf/2Q==");
    public static final String TEXT_CONTENT_TYPE = "text/plain";
    public static final String BINARY_CONTENT_TYPE = "image/jpeg";
    public static final String TEXT_NAME = "lorem_ipsum.txt";
    public static final String BINARY_NAME = "lorem_pixel.jpg";
    public static final ContentReadable TEXT_BYTE_ARRAY_CONTENT_READABLE = new ByteArrayContentReadable("Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum".getBytes(), "text/plain", "lorem_ipsum.txt");
    public static final ContentReadable BINARY_BYTE_ARRAY_CONTENT_READABLE = new ByteArrayContentReadable(BINARY, "image/jpeg", "lorem_pixel.jpg");
    public static final String TEXT_RESOURCE_LOCATION = "classpath:lorem_ipsum.txt";
    public static final String BINARY_RESOURCE_LOCATION = "classpath:lorem_pixel.jpg";
    public static final ContentReadable TEXT_RESOURCE_CONTENT_READABLE = new ResourceContentReadable("classpath:lorem_ipsum.txt", "text/plain");
    public static final ContentReadable BINARY_RESOURCE_CONTENT_READABLE = new ResourceContentReadable("classpath:lorem_pixel.jpg", "image/jpeg");

    public static final ContentReadable textStreamContentReadable() {
        return new StreamContentReadable((InputStream)new ByteArrayInputStream(TEXT.getBytes()), TEXT_CONTENT_TYPE, TEXT_NAME);
    }

    public static final ContentReadable binaryStreamContentReadable() {
        return new StreamContentReadable((InputStream)new ByteArrayInputStream(BINARY), BINARY_CONTENT_TYPE, BINARY_NAME);
    }

    public static final ContentReadable textSlowByteArrayContentReadable() {
        return new StreamContentReadable((InputStream)new SlowByteArrayInputStream(TEXT.getBytes()), TEXT_CONTENT_TYPE, TEXT_NAME);
    }

    public static final ContentReadable binarySlowByteArrayContentReadable() {
        return new StreamContentReadable((InputStream)new SlowByteArrayInputStream(BINARY), BINARY_CONTENT_TYPE, BINARY_NAME);
    }

    public static final ContentReadable textSlowStreamSourceContentReadable() {
        return new StreamSourceContentReadable((InputStreamSource)new SlowInputStreamSource(TEXT.getBytes()), TEXT_CONTENT_TYPE, TEXT_NAME);
    }

    public static final ContentReadable binarySlowStreamSourceContentReadable() {
        return new StreamSourceContentReadable((InputStreamSource)new SlowInputStreamSource(BINARY), BINARY_CONTENT_TYPE, BINARY_NAME);
    }

    private TestConstants() {
    }
}

