/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.util;

import cloud.altemista.fwk.common.annotation.HiddenValue;
import java.lang.annotation.Annotation;
import org.apache.commons.lang3.StringUtils;

public final class ToStringUtil {
    private ToStringUtil() {
    }

    public static String toString(Object object) {
        return object == null ? "null" : object.toString();
    }

    public static String toString(Object object, int maxLength) {
        return ToStringUtil.abbreviate(ToStringUtil.toString(object), maxLength);
    }

    public static String hiddenAwareToString(Object object) {
        if (object == null) {
            return "null";
        }
        HiddenValue hiddenValue = object.getClass().getAnnotation(HiddenValue.class);
        return hiddenValue != null ? hiddenValue.value() : object.toString();
    }

    public static String hiddenAwareToString(Object object, int maxLength) {
        return ToStringUtil.abbreviate(ToStringUtil.hiddenAwareToString(object), maxLength);
    }

    public static String hiddenAwareToString(Object object, Annotation[] annotations) {
        if (annotations != null && annotations.length != 0) {
            for (Annotation annotation : annotations) {
                if (!HiddenValue.class.equals(annotation.annotationType())) continue;
                return ((HiddenValue)annotation).value();
            }
        }
        return ToStringUtil.hiddenAwareToString(object);
    }

    public static String hiddenAwareToString(Object object, Annotation[] annotations, int maxLength) {
        return ToStringUtil.abbreviate(ToStringUtil.hiddenAwareToString(object, annotations), maxLength);
    }

    private static String abbreviate(String string, int maxLength) {
        return StringUtils.abbreviate((String)string, (int)Math.max(4, maxLength));
    }
}

