/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.util;

import cloud.altemista.fwk.common.util.ArrayUtil;
import java.text.Format;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public final class SqlUtil {
    private static final char PLACEHOLDER = '?';
    private static final char QUOTE = '\'';
    private static final String QUOTE_STRING = Character.toString('\'');
    private static final String QUOTED_QUOTE_STRING = "''";
    private static final String STRING_FORMAT = "'%s'";
    private static final String LIST_FORMAT = "(%s)";
    private static final String UNKNOWN_FORMAT = "<%s>";
    private static final String PARAMETERS_SEPARATOR = ", ";
    private static final Format DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS");

    private SqlUtil() {
    }

    public static int findPlaceholder(String query, int index) {
        int i;
        if (StringUtils.isEmpty((CharSequence)query)) {
            return -1;
        }
        if (index < 0 || index >= query.length()) {
            return -1;
        }
        boolean isQuoted = false;
        for (i = 0; i < index; ++i) {
            isQuoted ^= query.charAt(i) == '\'';
        }
        int n = query.length();
        while (i < n) {
            char c = query.charAt(i);
            if (c == '?' && !isQuoted) {
                return i;
            }
            isQuoted ^= c == '\'';
            ++i;
        }
        return -1;
    }

    public static int countPlaceholders(String query) {
        if (StringUtils.isEmpty((CharSequence)query)) {
            return 0;
        }
        int count = 0;
        boolean isQuoted = false;
        int n = query.length();
        for (int i = 0; i < n; ++i) {
            char c = query.charAt(i);
            if (c == '?' && !isQuoted) {
                ++count;
            }
            isQuoted ^= c == '\'';
        }
        return count;
    }

    public static String replacePlaceholder(String query, List<?> parameters) {
        if (StringUtils.isEmpty((CharSequence)query)) {
            return "";
        }
        if (CollectionUtils.isEmpty(parameters)) {
            return StringUtils.trimToEmpty((String)query);
        }
        StringBuilder sb = new StringBuilder();
        int begin = 0;
        for (Object parameter : parameters) {
            int index = SqlUtil.findPlaceholder(query, begin);
            if (index < 0) break;
            sb.append(query.substring(begin, index)).append(SqlUtil.parameterToString(parameter));
            begin = index + 1;
        }
        sb.append(query.substring(begin));
        return sb.toString();
    }

    public static String parametersToString(Object[] parameters) {
        if (ArrayUtils.isEmpty((Object[])parameters)) {
            return "";
        }
        ArrayList<String> formattedParameters = new ArrayList<String>();
        for (Object parameter : parameters) {
            formattedParameters.add(SqlUtil.parameterToString(parameter));
        }
        return StringUtils.join(formattedParameters, (String)PARAMETERS_SEPARATOR);
    }

    public static String parametersToString(Collection<?> parameters) {
        if (CollectionUtils.isEmpty(parameters)) {
            return "";
        }
        ArrayList<String> formattedParameters = new ArrayList<String>();
        for (Object parameter : parameters) {
            formattedParameters.add(SqlUtil.parameterToString(parameter));
        }
        return StringUtils.join(formattedParameters, (String)PARAMETERS_SEPARATOR);
    }

    public static String parameterToString(Object parameter) {
        if (parameter == null) {
            return "null";
        }
        if (parameter.getClass().isArray()) {
            return String.format(LIST_FORMAT, SqlUtil.parametersToString(ArrayUtil.toObjectArray(parameter)));
        }
        if (parameter instanceof Collection) {
            return String.format(LIST_FORMAT, SqlUtil.parametersToString((Collection)parameter));
        }
        if (parameter instanceof CharSequence || parameter instanceof Character) {
            return String.format(STRING_FORMAT, StringUtils.replace((String)parameter.toString(), (String)QUOTE_STRING, (String)QUOTED_QUOTE_STRING));
        }
        if (parameter instanceof Date || parameter instanceof Calendar) {
            return String.format(STRING_FORMAT, DATE_FORMAT.format(parameter));
        }
        Class<?> parameterClass = parameter.getClass();
        if (ClassUtils.isPrimitiveOrWrapper(parameterClass)) {
            return parameter.toString();
        }
        return String.format(UNKNOWN_FORMAT, parameterClass);
    }
}

