/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.util;

import cloud.altemista.fwk.common.exception.CommonException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static File getFile(String resourceLocation) {
        if (!StringUtils.hasText((String)resourceLocation)) {
            return null;
        }
        try {
            File file = ResourceUtils.getFile((String)resourceLocation);
            if (file.exists() && !file.isDirectory() && file.canRead()) {
                return file;
            }
            return null;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static InputStream getInputStream(String resourceLocation) {
        try {
            return ResourceUtils.getURL((String)resourceLocation).openStream();
        }
        catch (IOException e) {
            throw new CommonException("resource_not_found", new Object[]{resourceLocation}, (Throwable)e);
        }
    }
}

