/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.util;

import cloud.altemista.fwk.common.annotation.HiddenValue;
import cloud.altemista.fwk.common.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.util.ReflectionUtils;

public final class ReflectionToStringUtil {
    private static final String[] OBJECT_TOSTRING_PACKAGES = new String[]{"java.", "javax.", "org.springframework", "org.apache.", "org.joda.time."};
    private static final ReflectionUtils.FieldFilter BEAN_FIELDS_FIELD_FILTER = new ReflectionUtil.WithoutAnyModifiersFieldFilter(200);
    private final int maxLength;
    private final int maxDepth;
    private final int stopPrintingAfter;
    private List<Pair<Long, Object>> knownIds;
    private AtomicLong currentId;

    private ReflectionToStringUtil(int maxLength, int maxDepth, int stopPrintingAfter) {
        this.maxLength = Math.max(4, maxLength);
        this.maxDepth = Math.max(1, maxDepth);
        this.stopPrintingAfter = Math.max(4, stopPrintingAfter);
        this.knownIds = new ArrayList<Pair<Long, Object>>();
        this.currentId = new AtomicLong(0L);
    }

    public static String toString(Object object) {
        return ReflectionToStringUtil.toString(object, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static String toString(Object object, Annotation[] annotations) {
        if (annotations != null && annotations.length != 0) {
            for (Annotation annotation : annotations) {
                if (!HiddenValue.class.equals(annotation.annotationType())) continue;
                return ((HiddenValue)annotation).value();
            }
        }
        return ReflectionToStringUtil.toString(object);
    }

    public static String toString(Object object, int maxLength, int maxDepth, int stopPrintingAfter) {
        if (object == null) {
            return "null";
        }
        HiddenValue hiddenValue = object.getClass().getAnnotation(HiddenValue.class);
        if (hiddenValue != null) {
            return StringUtils.abbreviate((String)hiddenValue.value(), (int)Math.max(4, maxLength));
        }
        return new ReflectionToStringUtil(maxLength, maxDepth, stopPrintingAfter).toStringObject(object);
    }

    public static String toString(Object object, Annotation[] annotations, int maxLength, int maxDepth, int stopPrintingAfter) {
        if (annotations != null && annotations.length != 0) {
            for (Annotation annotation : annotations) {
                if (!HiddenValue.class.equals(annotation.annotationType())) continue;
                return ((HiddenValue)annotation).value();
            }
        }
        return ReflectionToStringUtil.toString(object, maxLength, maxDepth, stopPrintingAfter);
    }

    private String toStringObject(Object object) {
        return this.toStringObject(object, 0);
    }

    private String toStringObject(Object object, int depth) {
        if (depth == this.maxDepth) {
            return "";
        }
        if (object == null) {
            return "null";
        }
        HiddenValue hiddenValue = object.getClass().getAnnotation(HiddenValue.class);
        if (hiddenValue != null) {
            return this.abbreviateElement(hiddenValue.value());
        }
        for (Pair<Long, Object> knownId : this.knownIds) {
            if (knownId.getRight() != object) continue;
            return this.useReference(object.getClass(), (Long)knownId.getLeft());
        }
        Class<?> lClass = object.getClass();
        if (ClassUtils.isPrimitiveOrWrapper(lClass) || object instanceof Enum) {
            return this.abbreviateElement(object.toString());
        }
        if (BooleanUtils.isNotFalse((Boolean)this.isUninitializedHibernateProxy(object, "org.hibernate.collection.PersistentCollection"))) {
            return "<hibernate.PersistentCollection>";
        }
        if (BooleanUtils.isNotFalse((Boolean)this.isUninitializedHibernateProxy(object, "org.hibernate.proxy.HibernateProxy"))) {
            return "<hibernate.HibernateProxy>";
        }
        if (lClass.isArray()) {
            return this.toStringArray(object, depth);
        }
        if (object instanceof Collection) {
            return this.toStringCollection((Collection)object, depth);
        }
        if (object instanceof Map) {
            return this.toStringMap((Map)object, depth);
        }
        if (object instanceof CharSequence) {
            return String.format("\"%s\"", this.abbreviateElement(object.toString()));
        }
        Package lPackage = lClass.getPackage();
        if (lPackage != null && StringUtils.startsWithAny((CharSequence)lPackage.getName(), (CharSequence[])OBJECT_TOSTRING_PACKAGES)) {
            return this.abbreviateElement(object.toString());
        }
        return this.toStringBean(object, depth);
    }

    private String toStringArray(Object array, int depth) {
        int length = Array.getLength(array);
        if (length == 0) {
            return "[]";
        }
        if (array instanceof byte[]) {
            return "<[" + length + " bytes]>";
        }
        if (array instanceof char[]) {
            return "<[" + length + " chars]>";
        }
        if (depth + 1 == this.maxDepth) {
            return String.format("<%s:[%d]>", ClassUtils.getShortClassName(array.getClass()), length);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.createReference(array));
        sb.append("[");
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            sb.append(this.toStringObject(element));
            if (i >= length - 1) continue;
            if (sb.length() <= this.stopPrintingAfter) {
                sb.append(", ");
                continue;
            }
            sb.append("... <").append(length).append(">");
            break;
        }
        return sb.append("]>").toString();
    }

    private String toStringCollection(Collection<?> collection, int depth) {
        int size = collection.size();
        if (size == 0) {
            return String.format("<%s:[]>", ClassUtils.getShortClassName(collection.getClass()));
        }
        if (depth + 1 == this.maxDepth) {
            return String.format("<%s:[%d]>", ClassUtils.getShortClassName(collection.getClass()), size);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.createReference(collection));
        sb.append("[");
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            sb.append(this.toStringObject(element));
            if (!it.hasNext()) continue;
            if (sb.length() <= this.stopPrintingAfter) {
                sb.append(", ");
                continue;
            }
            sb.append("... <").append(size).append(">");
            break;
        }
        return sb.append("]>").toString();
    }

    private String toStringMap(Map<Object, Object> map, int depth) {
        int size = map.size();
        if (size == 0) {
            return String.format("<%s:{}>", ClassUtils.getShortClassName(map.getClass()));
        }
        if (depth + 1 == this.maxDepth) {
            return String.format("<%s:{<%d>}>", ClassUtils.getShortClassName(map.getClass()), size);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.createReference(map));
        sb.append("{");
        Iterator<Map.Entry<Object, Object>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            sb.append(this.toStringObject(entry.getKey(), depth + 1));
            sb.append("=");
            sb.append(this.toStringObject(entry.getValue(), depth + 1));
            if (!it.hasNext()) continue;
            if (sb.length() <= this.stopPrintingAfter) {
                sb.append(", ");
                continue;
            }
            sb.append("... <").append(size).append(">");
            break;
        }
        return sb.append("}>").toString();
    }

    private String toStringBean(Object object, int depth) {
        Map<String, Object> map;
        if (depth + 1 == this.maxDepth) {
            return this.createClosedReference(object);
        }
        try {
            BeanToMapCallback callback = new BeanToMapCallback(object);
            ReflectionUtils.doWithFields(object.getClass(), (ReflectionUtils.FieldCallback)callback, (ReflectionUtils.FieldFilter)BEAN_FIELDS_FIELD_FILTER);
            map = callback.getMap();
        }
        catch (IllegalStateException e) {
            return this.abbreviateElement(object.toString());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.createReference(object));
        sb.append("{");
        Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            sb.append(entry.getKey()).append("=").append(this.toStringObject(entry.getValue(), depth + 1));
            if (!it.hasNext()) continue;
            if (sb.length() <= this.stopPrintingAfter) {
                sb.append(", ");
                continue;
            }
            sb.append("... <").append(map.size()).append(">");
            break;
        }
        return sb.append("}>").toString();
    }

    private String abbreviateElement(String string) {
        return StringUtils.abbreviate((String)string, (int)this.maxLength);
    }

    private String createClosedReference(Object object) {
        long id = this.currentId.incrementAndGet();
        this.knownIds.add((Pair<Long, Object>)new ImmutablePair((Object)id, object));
        return String.format("<%s:%d>", ClassUtils.getShortClassName(object.getClass()), id);
    }

    private String createReference(Object object) {
        long id = this.currentId.incrementAndGet();
        this.knownIds.add((Pair<Long, Object>)new ImmutablePair((Object)id, object));
        return String.format("<%s:%d:", ClassUtils.getShortClassName(object.getClass()), id);
    }

    private String useReference(Class<?> pClass, long id) {
        return String.format("<%s:%d>", ClassUtils.getShortClassName(pClass), id);
    }

    private Boolean isUninitializedHibernateProxy(Object object, String ... interfaceNames) {
        if (!this.isHibernateProxy(object, interfaceNames)) {
            return false;
        }
        try {
            Method method = ReflectionUtil.getMethod("org.hibernate.Hibernate", "isInitialized", Object.class);
            if (method == null) {
                return null;
            }
            Boolean isInitialized = (Boolean)method.invoke(null, object);
            return BooleanUtils.isNotTrue((Boolean)isInitialized);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isHibernateProxy(Object object, String ... interfaceNames) {
        Class<?> lClass = object.getClass();
        Class<?>[] interfaces = lClass.getInterfaces();
        for (String interfaceName : interfaceNames) {
            if (lClass.getName().equals(interfaceName)) {
                return true;
            }
            for (Class<?> lInterface : interfaces) {
                if (!lInterface.getName().equals(interfaceName)) continue;
                return true;
            }
        }
        return false;
    }

    private static class BeanToMapCallback
    implements ReflectionUtils.FieldCallback {
        private Object object;
        private Map<String, Object> map = new TreeMap<String, Object>();

        public BeanToMapCallback(Object object) {
            this.object = object;
        }

        public void doWith(Field field) throws IllegalAccessException {
            HiddenValue hiddenValue = field.getAnnotation(HiddenValue.class);
            if (hiddenValue != null) {
                this.map.put(field.getName(), hiddenValue.value());
                return;
            }
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            Object value = field.get(this.object);
            this.map.put(field.getName(), value);
            field.setAccessible(accessible);
        }

        public Map<String, Object> getMap() {
            return this.map;
        }
    }
}

