/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <E> List<E> asList(Collection<E> collection) {
        if (collection == null) {
            return Collections.emptyList();
        }
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<E>(collection);
    }

    public static <E> List<E> page(Collection<E> collection, int offset, int pageSize) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        return CollectionUtil.page(CollectionUtil.asList(collection), offset, pageSize);
    }

    public static <E> List<E> page(List<E> list, int pOffset, int pPageSize) {
        int pageSize;
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        int offset = pOffset;
        if (offset < 0) {
            offset = 0;
        }
        if (offset >= list.size()) {
            offset = list.size();
        }
        if ((pageSize = pPageSize) < 0) {
            pageSize = 0;
        }
        if (offset + pageSize >= list.size()) {
            pageSize = list.size() - offset;
        }
        return new ArrayList<E>(list.subList(offset, offset + pageSize));
    }
}

