/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.model;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.InputStreamSource;

public class TempMixedOutputStream
extends FilterOutputStream
implements InputStreamSource {
    private static final String DEFAULT_PREFIX = "altemista_cloud_";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private byte[] buf;
    private int count;
    private String prefix;
    private String suffix;
    private File file;

    public TempMixedOutputStream() {
        this(DEFAULT_PREFIX, null, 8192);
    }

    public TempMixedOutputStream(String prefix) {
        this(prefix, null, 8192);
    }

    public TempMixedOutputStream(String prefix, String suffix) {
        this(prefix, suffix, 8192);
    }

    public TempMixedOutputStream(int size) {
        this(DEFAULT_PREFIX, null, size);
    }

    public TempMixedOutputStream(String prefix, int size) {
        this(prefix, null, size);
    }

    public TempMixedOutputStream(String prefix, String suffix, int size) {
        super(null);
        if (StringUtils.length((CharSequence)prefix) < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
        this.count = 0;
        this.prefix = prefix;
        this.suffix = suffix;
        this.file = null;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.out != null) {
            super.write(b);
        } else {
            if (this.count < this.buf.length) {
                this.buf[this.count++] = (byte)b;
            }
            if (this.count == this.buf.length) {
                this.file = File.createTempFile(this.prefix, this.suffix);
                this.file.deleteOnExit();
                this.out = new BufferedOutputStream(FileUtils.openOutputStream((File)this.file));
                super.write(this.buf, 0, this.count);
                this.buf = null;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            super.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            super.close();
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            this.flush();
            return FileUtils.openInputStream((File)this.file);
        }
        return new ByteArrayInputStream(this.buf, 0, this.count);
    }
}

