/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.model;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.InputStreamSource;

public class TempFileOutputStream
extends FilterOutputStream
implements InputStreamSource {
    private static final String DEFAULT_PREFIX = "altemista_cloud_";
    private File file;

    public TempFileOutputStream() throws IOException {
        this(DEFAULT_PREFIX, null);
    }

    public TempFileOutputStream(String prefix) throws IOException {
        this(prefix, null);
    }

    public TempFileOutputStream(String prefix, String suffix) throws IOException {
        super(null);
        this.file = File.createTempFile(StringUtils.defaultString((String)prefix, (String)DEFAULT_PREFIX), suffix);
        this.file.deleteOnExit();
        this.out = new BufferedOutputStream(FileUtils.openOutputStream((File)this.file));
    }

    public InputStream getInputStream() throws IOException {
        this.flush();
        return FileUtils.openInputStream((File)this.file);
    }
}

