/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.model;

import cloud.altemista.fwk.common.exception.CommonException;
import cloud.altemista.fwk.common.model.AbstractContent;
import cloud.altemista.fwk.common.model.ContentReadable;
import com.google.common.base.Objects;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.InputStreamSource;

public class StreamSourceContentReadable
extends AbstractContent
implements ContentReadable,
InputStreamSource {
    private InputStreamSource inputStreamSource;

    public StreamSourceContentReadable() {
    }

    public StreamSourceContentReadable(InputStreamSource inputStreamSource) {
        this.inputStreamSource = inputStreamSource;
    }

    public StreamSourceContentReadable(InputStreamSource inputStreamSource, String contentType, String path) {
        super(contentType, path);
        this.inputStreamSource = inputStreamSource;
    }

    @Override
    public InputStream getInputStream() {
        if (this.inputStreamSource == null) {
            return null;
        }
        try {
            return this.inputStreamSource.getInputStream();
        }
        catch (IOException e) {
            throw new CommonException("input_stream_source", e);
        }
    }

    @Override
    public Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("inputStreamSource", (Object)this.inputStreamSource);
    }

    public InputStreamSource getInputStreamSource() {
        return this.inputStreamSource;
    }

    public void setInputStreamSource(InputStreamSource inputStreamSource) {
        this.inputStreamSource = inputStreamSource;
    }
}

