/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.model;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;

public class SparseList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Serializable {
    private static final long serialVersionUID = -1856211286260612425L;
    private Map<Integer, E> elements;
    private int offset;
    private int size;

    public SparseList(Map<Integer, E> elements) {
        this(elements, 0);
    }

    public SparseList(Map<Integer, E> elements, int offset) {
        if (elements == null) {
            this.elements = Collections.emptyMap();
            this.offset = 0;
            this.size = 0;
        } else {
            int minIndex = Collections.min(elements.keySet());
            if (minIndex < offset) {
                throw new IndexOutOfBoundsException("Index: " + minIndex + ", Offset: " + offset);
            }
            this.elements = new HashMap<Integer, E>(elements);
            this.offset = offset;
            this.size = Collections.max(elements.keySet()) - offset + 1;
        }
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.elements.get(index + this.offset);
    }

    @Override
    public int size() {
        return this.size;
    }
}

