/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.model;

import cloud.altemista.fwk.common.util.DefensiveUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.util.Assert;

public final class ContentType
implements Serializable {
    private static final long serialVersionUID = -5500564710409634612L;
    public static final ContentType CSV = ContentType.register("text/csv", "csv");
    public static final ContentType HTML = ContentType.register("text/html", "html", "htm");
    public static final ContentType MS_EXCEL = ContentType.register("application/vnd.ms-excel", "xls");
    public static final ContentType MS_POWERPOINT = ContentType.register("application/vnd.ms-powerpoint", "ppt");
    public static final ContentType MS_WORD = ContentType.register("application/msword", "doc");
    public static final ContentType OOXML_EXCEL = ContentType.register("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx");
    public static final ContentType OOXML_WORD = ContentType.register("application/vnd.openxmlformats-officedocument.wordprocessingml.sheet", "docx");
    public static final ContentType OOXML_POWERPOINT = ContentType.register("application/vnd.openxmlformats-officedocument.presentationml.sheet", "pptx");
    public static final ContentType PDF = ContentType.register("application/pdf", "pdf");
    public static final ContentType RTF = ContentType.register("application/rtf", "rtf");
    public static final ContentType TEXT = ContentType.register("text/plain", "txt");
    public static final ContentType XML = ContentType.register("application/xml", "xml");
    private String contentType;
    private List<String> extensions;

    private ContentType(String contentType, String ... extensions) {
        this.contentType = contentType;
        this.extensions = DefensiveUtil.unmodifiableList(extensions);
    }

    public static ContentType register(String pContentType, String ... pExtensions) {
        String lContentType = StringUtils.trimToNull((String)pContentType);
        Assert.notNull((Object)lContentType, (String)"The content type is mandatory");
        ArrayList<String> extensions = new ArrayList<String>();
        if (pExtensions != null) {
            for (String extension : pExtensions) {
                if (!StringUtils.isNotBlank((CharSequence)extension)) continue;
                extensions.add(StringUtils.trim((String)extension));
            }
        }
        Assert.notEmpty(extensions, (String)"At least one extension is mandatory");
        ContentType contentType = new ContentType(lContentType, extensions.toArray(new String[extensions.size()]));
        ContentTypeRegister.SET.add(contentType);
        return contentType;
    }

    public static ContentType fromContentType(String pContentType) {
        String contentType = StringUtils.trimToNull((String)pContentType);
        if (contentType == null) {
            return null;
        }
        for (ContentType it : ContentTypeRegister.SET) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)it.contentType)) continue;
            return it;
        }
        return null;
    }

    public static ContentType fromFilename(String pFilename) {
        String filename = StringUtils.trimToNull((String)pFilename);
        if (filename == null) {
            return null;
        }
        return ContentType.fromExtension(FilenameUtils.getExtension((String)filename));
    }

    public static ContentType fromExtension(String pExtension) {
        String extension = StringUtils.trimToNull((String)pExtension);
        if (extension == null) {
            return null;
        }
        for (ContentType it : ContentTypeRegister.SET) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)extension, (CharSequence)it.getDefaultExtension())) continue;
            return it;
        }
        for (ContentType it : ContentTypeRegister.SET) {
            for (String itExtension : it.extensions) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)extension, (CharSequence)itExtension)) continue;
                return it;
            }
        }
        return null;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getDefaultExtension() {
        return this.extensions.iterator().next();
    }

    public String[] getKnownExtensions() {
        return this.extensions == null ? null : this.extensions.toArray(new String[this.extensions.size()]);
    }

    public boolean isProperFilename(String pFilename) {
        String filename = StringUtils.trimToNull((String)pFilename);
        if (filename == null) {
            return false;
        }
        return this.isProperExtension(FilenameUtils.getExtension((String)filename));
    }

    public boolean isProperExtension(String pExtension) {
        String extension = StringUtils.trimToNull((String)pExtension);
        if (extension == null) {
            return false;
        }
        for (String it : this.extensions) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)extension, (CharSequence)it)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("contentType", (Object)this.contentType).append("extensions", this.extensions).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.contentType).append(this.extensions).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ContentType that = (ContentType)obj;
        return new EqualsBuilder().append((Object)this.contentType, (Object)that.contentType).append(this.extensions, that.extensions).isEquals();
    }

    private static final class ContentTypeRegister {
        private static final Set<ContentType> SET = new HashSet<ContentType>();

        private ContentTypeRegister() {
        }
    }
}

